/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.LogicalSide;

public class MobEnchantedMessage {
    private int entityId;
    private MobEnchant enchantType;
    private int level;

    public MobEnchantedMessage(Entity entity, MobEnchantHandler enchantType) {
        this.entityId = entity.m_19879_();
        this.enchantType = enchantType.getMobEnchant();
        this.level = enchantType.getEnchantLevel();
    }

    public MobEnchantedMessage(int id, MobEnchantHandler enchantType) {
        this.entityId = id;
        this.enchantType = enchantType.getMobEnchant();
        this.level = enchantType.getEnchantLevel();
    }

    public MobEnchantedMessage(Entity entity, MobEnchant enchantType, int level) {
        this.entityId = entity.m_19879_();
        this.enchantType = enchantType;
        this.level = level;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeRegistryId(MobEnchants.getRegistry().get(), (Object)this.enchantType);
        buffer.writeInt(this.level);
    }

    public static MobEnchantedMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        MobEnchant enchantType = (MobEnchant)buffer.readRegistryId();
        int level = buffer.readInt();
        return new MobEnchantedMessage(entityId, new MobEnchantHandler(enchantType, level));
    }

    public void handle(CustomPayloadEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                IEnchantCap cap;
                LivingEntity livingEntity;
                Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(this.entityId);
                if (entity != null && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) instanceof IEnchantCap && !MobEnchantUtils.findMobEnchantHandler((cap = (IEnchantCap)livingEntity).getEnchantCap().getMobEnchants(), this.enchantType)) {
                    cap.getEnchantCap().addMobEnchant((LivingEntity)entity, this.enchantType, this.level);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

