/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.api.IBaguPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.NetworkEvent;

public class SyncEntityPacketToServer {
    private final UUID uuid;

    public SyncEntityPacketToServer(UUID uuid) {
        this.uuid = uuid;
    }

    public static void writeToPacket(SyncEntityPacketToServer packet, FriendlyByteBuf buf) {
        buf.writeUUID(packet.uuid);
    }

    public static SyncEntityPacketToServer readFromPacket(FriendlyByteBuf buf) {
        return new SyncEntityPacketToServer(buf.readUUID());
    }

    public void handle(NetworkEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                Entity entity = ((ServerLevel)player.level()).getEntity(this.uuid);
                if (entity instanceof IBaguPacket) {
                    IBaguPacket baguPacket = (IBaguPacket)entity;
                    baguPacket.resync(entity, entity.getId());
                }
            });
        }
        context.setPacketHandled(true);
    }
}

