/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.item;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MobEnchantBookItem
extends Item {
    public MobEnchantBookItem(Item.Properties group) {
        super(group);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (((Boolean)EnchantConfig.COMMON.enchantYourSelf.get()).booleanValue() && MobEnchantUtils.hasMobEnchant(stack) && playerIn instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerIn;
            boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, (LivingEntity)playerIn, (LivingEntity)playerIn, cap);
            if (flag) {
                level.playSound(playerIn, playerIn.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                playerIn.getCooldowns().addCooldown(stack.getItem(), 40);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.enchant_yourself"), true);
            playerIn.getCooldowns().addCooldown(stack.getItem(), 20);
            return InteractionResultHolder.fail((Object)stack);
        }
        return super.use(level, playerIn, handIn);
    }

    public static List<ItemStack> generateMobEnchantmentBookTypesOnlyMaxLevel() {
        ArrayList items = Lists.newArrayList();
        for (MobEnchant mobEnchant : MobEnchants.getRegistry()) {
            if (mobEnchant.isDisabled()) continue;
            ItemStack stack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
            MobEnchantUtils.addMobEnchantToItemStack(stack, mobEnchant, mobEnchant.getMaxLevel());
            items.add(stack);
        }
        for (MobEnchant mobEnchant : MobEnchants.getRegistry()) {
            if (mobEnchant.isDisabled()) continue;
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
            MobEnchantUtils.addMobEnchantToItemStack(stack2, mobEnchant, mobEnchant.getMaxLevel());
            items.add(stack2);
        }
        return items;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.appendHoverText(stack, level, tooltip, p_41424_);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        tooltip.add((Component)Component.translatable((String)"mobenchant.enchantwithmob.mob_enchant_book.tooltip").withStyle(textformatting2));
        if (MobEnchantUtils.hasMobEnchant(stack)) {
            ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.getTag());
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.getCompound(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int enchantmentLevel = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null) continue;
                ChatFormatting[] textformatting = new ChatFormatting[]{ChatFormatting.AQUA};
                ChatFormatting[] textformatting3 = new ChatFormatting[]{ChatFormatting.RED};
                tooltip.add((Component)Component.translatable((String)("mobenchant." + MobEnchants.getRegistry().getKey((Object)mobEnchant).getNamespace() + "." + MobEnchants.getRegistry().getKey((Object)mobEnchant).getPath())).withStyle(mobEnchant.isCursedEnchant() ? textformatting3 : textformatting).append(" ").append((Component)Component.translatable((String)("enchantment.level." + enchantmentLevel)).withStyle(mobEnchant.isCursedEnchant() ? textformatting3 : textformatting)));
            }
            ArrayList list1 = Lists.newArrayList();
            for (int i = 0; i < listnbt.size(); ++i) {
                Map<Attribute, AttributeModifier> map;
                CompoundTag compoundnbt = listnbt.getCompound(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int mobEnchantLevel = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null || (map = mobEnchant.getAttributeModifierMap()).isEmpty()) continue;
                for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                    AttributeModifier attributemodifier = entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), mobEnchant.getAttributeModifierAmount(mobEnchantLevel, attributemodifier), attributemodifier.getOperation());
                    list1.add(new Pair((Object)entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (!list1.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"mobenchant.enchantwithmob.when_ehcnanted").withStyle(ChatFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.getAmount();
                    double d1 = attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

