/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.api.IEnchantCap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.NetworkEvent;

public class MobEnchantFromOwnerMessage {
    private int entityId;
    private int ownerID;

    public MobEnchantFromOwnerMessage(Entity entity, Entity ownerEntity) {
        this.entityId = entity.getId();
        this.ownerID = ownerEntity.getId();
    }

    public MobEnchantFromOwnerMessage(int id, int ownerID) {
        this.entityId = id;
        this.ownerID = ownerID;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.ownerID);
    }

    public static MobEnchantFromOwnerMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        int ownerId = buffer.readInt();
        return new MobEnchantFromOwnerMessage(entityId, ownerId);
    }

    public boolean handle(NetworkEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                LivingEntity livingEntity;
                Entity entity = Minecraft.getInstance().player.level().getEntity(this.entityId);
                Entity ownerEntity = Minecraft.getInstance().player.level().getEntity(this.ownerID);
                if (entity != null && entity instanceof LivingEntity && ownerEntity != null && ownerEntity instanceof LivingEntity && (livingEntity = (LivingEntity)ownerEntity) instanceof IEnchantCap) {
                    IEnchantCap cap = (IEnchantCap)livingEntity;
                    cap.getEnchantCap().addOwner((LivingEntity)entity, (LivingEntity)ownerEntity);
                }
            });
        }
        context.setPacketHandled(true);
        return true;
    }
}

