/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.NetworkEvent;

public class SoulParticleMessage {
    private int entityId;

    public SoulParticleMessage(Entity entity) {
        this.entityId = entity.getId();
    }

    public SoulParticleMessage(int id) {
        this.entityId = id;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    public static SoulParticleMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        return new SoulParticleMessage(entityId);
    }

    public boolean handle(NetworkEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
                if (entity != null) {
                    for (int i = 0; i < 4; ++i) {
                        entity.level().addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0.0, (double)0.1f, 0.0);
                    }
                }
            });
        }
        context.setPacketHandled(true);
        return true;
    }
}

