/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mixin;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.api.IEnchantedTime;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class}, remap=false)
public class EntityMixin
implements IEnchantedTime {
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    private float eyeHeight;
    private float differentTime = 1.0f;

    @Override
    public float getDifferentTime() {
        return this.differentTime;
    }

    @Override
    public void setDifferentTime(float time) {
        this.differentTime = time;
    }

    @Inject(method={"refreshDimensions"}, at={@At(value="RETURN")})
    public void refreshDimensions(CallbackInfo callbackInfo) {
        IEnchantCap cap;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof IEnchantCap && (cap = (IEnchantCap)((Object)entityMixin)).getEnchantCap().hasEnchant()) {
            if (MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), MobEnchants.SMALL.get())) {
                int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), MobEnchants.SMALL.get());
                float cappedScale = Mth.clamp((float)(0.15f * (float)level), (float)0.0f, (float)0.9f);
                float totalWidth = this.dimensions.width * (1.0f - cappedScale);
                float totalHeight = this.dimensions.height * (1.0f - cappedScale);
                this.eyeHeight *= 1.0f - cappedScale;
                this.dimensions = EntityDimensions.fixed((float)totalWidth, (float)totalHeight);
            } else if (MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), MobEnchants.HUGE.get())) {
                int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), MobEnchants.HUGE.get());
                float totalWidth = this.dimensions.width * (1.0f + (float)level * 0.15f);
                float totalHeight = this.dimensions.height * (1.0f + (float)level * 0.15f);
                this.eyeHeight *= 1.0f + (float)level * 0.15f;
                this.dimensions = EntityDimensions.fixed((float)totalWidth, (float)totalHeight);
            } else if (((Boolean)EnchantConfig.COMMON.changeSizeWhenEnchant.get()).booleanValue()) {
                float totalWidth = this.dimensions.width * 1.025f;
                float totalHeight = this.dimensions.height * 1.025f;
                this.eyeHeight *= 1.025f;
                this.dimensions = EntityDimensions.fixed((float)totalWidth, (float)totalHeight);
            }
        }
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }
}

