/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib;

import bagu_chan.bagus_lib.BagusConfigs;
import bagu_chan.bagus_lib.command.DialogCommand;
import bagu_chan.bagus_lib.message.CameraMessage;
import bagu_chan.bagus_lib.message.DialogMessage;
import bagu_chan.bagus_lib.message.EntityCameraMessage;
import bagu_chan.bagus_lib.message.ImageDialogMessage;
import bagu_chan.bagus_lib.message.ItemStackDialogMessage;
import bagu_chan.bagus_lib.message.PlayerDataSyncMessage;
import bagu_chan.bagus_lib.message.RemoveAllDialogMessage;
import bagu_chan.bagus_lib.message.SyncEntityPacketToServer;
import bagu_chan.bagus_lib.register.ModEntities;
import bagu_chan.bagus_lib.register.ModLootModifiers;
import bagu_chan.bagus_lib.register.ModSensors;
import bagu_chan.bagus_lib.register.ModStructureProcessorTypes;
import bagu_chan.bagus_lib.util.reward.TierHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bagus_lib")
public class BagusLib {
    public static final String MODID = "bagus_lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"bagus_lib");

    public BagusLib(IEventBus modEventBus) {
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModStructureProcessorTypes.PROCESSOR_TYPE.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        ModSensors.SENSOR_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupPackets);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BagusConfigs.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BagusConfigs.CLIENT_SPEC);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TierHelper.addSuporterContents();
    }

    public void setupPackets(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.play(CameraMessage.ID, CameraMessage::new, payload -> payload.client(CameraMessage::handle));
        registrar.play(EntityCameraMessage.ID, EntityCameraMessage::new, payload -> payload.client(EntityCameraMessage::handle));
        registrar.play(PlayerDataSyncMessage.ID, PlayerDataSyncMessage::new, payload -> payload.server(PlayerDataSyncMessage::handle));
        registrar.play(SyncEntityPacketToServer.ID, SyncEntityPacketToServer::new, payload -> payload.server(SyncEntityPacketToServer::handle));
        registrar.play(DialogMessage.ID, DialogMessage::new, payload -> payload.client(DialogMessage::handle));
        registrar.play(ImageDialogMessage.ID, ImageDialogMessage::new, payload -> payload.client(ImageDialogMessage::handle));
        registrar.play(ItemStackDialogMessage.ID, ItemStackDialogMessage::new, payload -> payload.client(ItemStackDialogMessage::handle));
        registrar.play(RemoveAllDialogMessage.ID, RemoveAllDialogMessage::new, payload -> payload.client(RemoveAllDialogMessage::handle));
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        DialogCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext());
    }
}

