/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.command;

import bagu_chan.bagus_lib.message.DialogMessage;
import bagu_chan.bagus_lib.message.ImageDialogMessage;
import bagu_chan.bagus_lib.message.ItemStackDialogMessage;
import bagu_chan.bagus_lib.message.RemoveAllDialogMessage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class DialogCommand {
    public static void register(CommandDispatcher<CommandSourceStack> p_138061_, CommandBuildContext p_214450_) {
        LiteralCommandNode literalcommandnode = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_dialog").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            if (!collection.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext)p_248155_, (String)"message", p_248154_ -> DialogCommand.sendDialogMessage((CommandSourceStack)p_248155_.getSource(), collection, p_248154_));
            }
            return collection.size();
        })))));
        LiteralCommandNode literalcommandnode2 = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_dialog").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"item_dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)p_214450_)).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            ItemInput item = ItemArgument.getItem((CommandContext)p_248155_, (String)"item");
            if (!collection.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext)p_248155_, (String)"message", p_248154_ -> DialogCommand.sendDialogItemMessage((CommandSourceStack)p_248155_.getSource(), collection, p_248154_, item));
            }
            return collection.size();
        }))))));
        LiteralCommandNode literalcommandnode3 = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_dialog").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"image_dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"image_path", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"size_x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"size_y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            ResourceLocation item = ResourceLocationArgument.getId((CommandContext)p_248155_, (String)"image_path");
            int sizeX = IntegerArgumentType.getInteger((CommandContext)p_248155_, (String)"size_x");
            int sizeY = IntegerArgumentType.getInteger((CommandContext)p_248155_, (String)"size_y");
            float scale = FloatArgumentType.getFloat((CommandContext)p_248155_, (String)"scale");
            if (!collection.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext)p_248155_, (String)"message", p_248154_ -> DialogCommand.sendDialogImageMessage((CommandSourceStack)p_248155_.getSource(), collection, p_248154_, item, sizeX, sizeY, scale));
            }
            return collection.size();
        })))))))));
        LiteralCommandNode literalcommandnode4 = p_138061_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bagus_dialog").requires(p_136627_ -> p_136627_.hasPermission(2))).then(Commands.literal((String)"remove_all_dialog").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(p_248155_ -> {
            Collection collection = EntityArgument.getPlayers((CommandContext)p_248155_, (String)"targets");
            if (!collection.isEmpty()) {
                DialogCommand.sendRemoveAllDialogMessage((CommandSourceStack)p_248155_.getSource(), collection);
            }
            return collection.size();
        }))));
    }

    private static void sendRemoveAllDialogMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_) {
        for (ServerPlayer serverplayer : p_252344_) {
            PacketDistributor.PLAYER.with((Object)serverplayer).send(new CustomPacketPayload[]{new RemoveAllDialogMessage()});
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.remove_all_dialog"));
    }

    private static void sendDialogMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_, PlayerChatMessage p_249416_) {
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create((PlayerChatMessage)p_249416_);
        for (ServerPlayer serverplayer : p_252344_) {
            PacketDistributor.PLAYER.with((Object)serverplayer).send(new CustomPacketPayload[]{new DialogMessage(outgoingchatmessage.content().getString())});
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.dialog"));
    }

    private static void sendDialogItemMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_, PlayerChatMessage p_249416_, ItemInput item) {
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create((PlayerChatMessage)p_249416_);
        for (ServerPlayer serverplayer : p_252344_) {
            try {
                PacketDistributor.PLAYER.with((Object)serverplayer).send(new CustomPacketPayload[]{new ItemStackDialogMessage(outgoingchatmessage.content().getString(), item.createItemStack(1, false))});
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.item_dialog"));
    }

    private static void sendDialogImageMessage(CommandSourceStack p_250209_, Collection<ServerPlayer> p_252344_, PlayerChatMessage p_249416_, ResourceLocation resourceLocation, int sizeX, int sizeY, float scale) {
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create((PlayerChatMessage)p_249416_);
        for (ServerPlayer serverplayer : p_252344_) {
            PacketDistributor.PLAYER.with((Object)serverplayer).send(new CustomPacketPayload[]{new ImageDialogMessage(outgoingchatmessage.content().getString(), resourceLocation, sizeX, sizeY, scale)});
        }
        p_250209_.sendSystemMessage((Component)Component.translatable((String)"command.bagus_lib.image_dialog"));
    }
}

