/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.BagusLib;
import bagu_chan.bagus_lib.api.IBaguData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PlayerDataSyncMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = BagusLib.prefix("player_data");
    private final CompoundTag tag;
    private int entityId;

    public PlayerDataSyncMessage(CompoundTag tag, Entity entity) {
        this.tag = tag;
        this.entityId = entity.getId();
    }

    public PlayerDataSyncMessage(CompoundTag tag, int entityId) {
        this.tag = tag;
        this.entityId = entityId;
    }

    public PlayerDataSyncMessage(FriendlyByteBuf buf) {
        this(buf.readNbt(), buf.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
        buf.writeInt(this.entityId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PlayerDataSyncMessage message, PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Object patt1638$temp;
            Optional player = context.player();
            if (player.isPresent() && (patt1638$temp = player.get()) instanceof IBaguData) {
                IBaguData data = (IBaguData)patt1638$temp;
                data.setBagusData(message.tag);
            }
        });
    }
}

