/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.client.render.layer.EnchantLayer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="enchantwithmob", value={Dist.CLIENT})
public class ClientEventHandler {
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP = new RenderStateShard.LightmapStateShard(true);
    protected static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEntityGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENERGY_SWIRL_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEnergySwirlShader);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> ClientEventHandler.setupGlintTexturing(0.16f), () -> RenderSystem.resetTextureMatrix());

    @SubscribeEvent
    public static void renderEnchantBeam(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity;
        IEnchantCap cap;
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource bufferBuilder = event.getMultiBufferSource();
        float particalTick = event.getPartialTick();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IEnchantCap && (cap = (IEnchantCap)livingEntity).getEnchantCap().hasOwner() && (entity = cap.getEnchantCap().getEnchantOwner()) != null) {
            ClientEventHandler.renderBeam(cap.getEnchantCap(), event.getEntity(), particalTick, matrixStack, bufferBuilder, (Entity)entity, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)event.getRenderer());
        }
    }

    public static Vec3 getPosition(Entity p_114803_, double p_114804_, float p_114805_) {
        double d0 = Mth.lerp((double)p_114805_, (double)p_114803_.xOld, (double)p_114803_.getX());
        double d1 = Mth.lerp((double)p_114805_, (double)p_114803_.yOld, (double)p_114803_.getY()) + p_114804_;
        double d2 = Mth.lerp((double)p_114805_, (double)p_114803_.zOld, (double)p_114803_.getZ());
        return new Vec3(d0, d1, d2);
    }

    protected static float getXRotD(LivingEntity livingEntity, Entity target, float totalTick) {
        double d0 = target.getPosition((float)totalTick).x - livingEntity.getPosition((float)totalTick).x;
        double d1 = target.getPosition((float)totalTick).y - livingEntity.getPosition((float)totalTick).y;
        double d2 = target.getPosition((float)totalTick).z - livingEntity.getPosition((float)totalTick).z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
    }

    protected static float getYRotD(LivingEntity livingEntity, Entity target, float totalTick) {
        double d0 = target.getPosition((float)totalTick).x - livingEntity.getPosition((float)totalTick).x;
        double d1 = target.getPosition((float)totalTick).z - livingEntity.getPosition((float)totalTick).z;
        return (float)(Mth.atan2((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    private static void renderBeam(@NotNull MobEnchantCapability cap, LivingEntity livingEntity, float totalTickTime, PoseStack poseStack, MultiBufferSource multiBufferSource, Entity target, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        poseStack.pushPose();
        double d3 = Mth.lerp((double)totalTickTime, (double)livingEntity.xo, (double)livingEntity.getX());
        double d4 = Mth.lerp((double)totalTickTime, (double)livingEntity.yo, (double)livingEntity.getY()) + (double)(livingEntity.getBbHeight() * 0.5f);
        double d5 = Mth.lerp((double)totalTickTime, (double)livingEntity.zo, (double)livingEntity.getZ());
        Vec3 vector3d = target.getEyePosition(totalTickTime);
        Vec3 vec31 = new Vec3(d3, d4, d5);
        Vec3 vec32 = vector3d.subtract(vec31);
        poseStack.translate(0.0f, livingEntity.getBbHeight() * 0.5f, 0.0f);
        float xRot = ClientEventHandler.getXRotD(livingEntity, target, totalTickTime);
        float yRot = ClientEventHandler.getYRotD(livingEntity, target, totalTickTime);
        poseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        Matrix4f matrix4f = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        float intensity = cap.getMobEnchants().size() < 3 ? (float)cap.getMobEnchants().size() / 3.0f : 3.0f;
        int intensityCacl = (int)(intensity / 3.0f * 255.0f);
        boolean i = true;
        float f = 1.0f;
        float f1 = totalTickTime;
        float f2 = f1 * 0.5f % 1.0f;
        float f4 = (float)(vec32.length() + 1.0);
        float f7 = f1 * 0.05f * -1.5f;
        int j = 255;
        int k = 255;
        int l = 255;
        float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
        float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
        float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
        float f27 = 0.0f;
        float f28 = 0.4999f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        VertexConsumer consumer = multiBufferSource.getBuffer(EnchantLayer.enchantBeamSwirl(cap.isAncient() ? EnchantLayer.ANCIENT_GLINT : ItemRenderer.ENCHANTED_GLINT_ENTITY));
        PoseStack.Pose posestack$pose = poseStack.last();
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30, intensity);
        float f31 = 0.0f;
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31, intensity);
        ClientEventHandler.vertex(consumer, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31, intensity);
        poseStack.popPose();
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int red, int green, int blue, float ux, float uz, float alpha) {
        vertexConsumer.vertex(matrix4f, x, y, z).color((float)red, (float)green, (float)blue, alpha).uv(ux, uz).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(0xF000F0).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
    }

    protected static int getBlockLightLevel(Entity p_225624_1_, BlockPos p_225624_2_) {
        return p_225624_1_.isOnFire() ? 15 : p_225624_1_.level().getBrightness(LightLayer.BLOCK, p_225624_2_);
    }

    private static void setupGlintTexturing(float p_110187_) {
        long i = Util.getMillis() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(p_110187_);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }
}

