/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.enchantwithmob.client.animation.EnchanterAnimation;
import baguchan.enchantwithmob.entity.EnchanterEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterModel<T extends EnchanterEntity>
extends HierarchicalModel<T>
implements IArmor {
    private final ModelPart realRoot;
    private final ModelPart everything;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart cape;

    public EnchanterModel(ModelPart everything) {
        this.realRoot = everything;
        this.everything = everything.getChild("everything");
        this.body = this.everything.getChild("body");
        this.cape = this.body.getChild("Cape");
        this.head = this.body.getChild("head");
        this.leftLeg = this.everything.getChild("left_leg");
        this.rightLeg = this.everything.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition Cape = body.addOrReplaceChild("Cape", CubeListBuilder.create().texOffs(0, 64).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 23.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 91).addBox(-5.0f, -14.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(6, 5).addBox(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(6, 5).addBox(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.addOrReplaceChild("righteyebrows", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.addOrReplaceChild("righteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.addOrReplaceChild("lefteyebrows", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.addOrReplaceChild("lefteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftHand = left_arm.addOrReplaceChild("leftHand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightHand = right_arm.addOrReplaceChild("rightHand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)11.0f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-0.95f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition book = everything.addOrReplaceChild("book", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-18.5f, (float)-9.0f));
        PartDefinition leftBookCover = book.addOrReplaceChild("leftBookCover", CubeListBuilder.create().texOffs(26, 75).addBox(-8.0f, -5.0f, -1.0f, 8.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 63).addBox(-6.5f, -4.0f, -0.25f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftPage = leftBookCover.addOrReplaceChild("leftPage", CubeListBuilder.create().texOffs(44, 63).addBox(-6.5f, -4.0f, -0.24f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightBookCover = book.addOrReplaceChild("rightBookCover", CubeListBuilder.create().texOffs(26, 63).addBox(0.0f, -5.0f, -1.0f, 8.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 63).addBox(0.5f, -4.0f, -0.25f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition rightPage = rightBookCover.addOrReplaceChild("rightPage", CubeListBuilder.create().texOffs(44, 63).addBox(0.5f, -4.0f, -0.24f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.cape.xRot = 0.1f + limbSwingAmount * 0.6f;
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((EnchanterEntity)((Object)entity)).getArmPose();
        if (this.riding) {
            this.applyStatic(EnchanterAnimation.ENCHANTER_SIT);
        }
        if (((EnchanterEntity)((Object)entity)).castingAnimationState.isStarted()) {
            this.animate(((EnchanterEntity)((Object)entity)).castingAnimationState, EnchanterAnimation.ENCHANTER_ENCHANCE, ageInTicks);
        }
        if (((EnchanterEntity)((Object)entity)).attackAnimationState.isStarted()) {
            this.animate(((EnchanterEntity)((Object)entity)).attackAnimationState, EnchanterAnimation.ENCHANTER_ATTACK, ageInTicks);
        }
        if (!((EnchanterEntity)((Object)entity)).castingAnimationState.isStarted() && !((EnchanterEntity)((Object)entity)).attackAnimationState.isStarted()) {
            this.animate(((EnchanterEntity)((Object)entity)).idleAnimationState, EnchanterAnimation.ENCHANTER_IDLE, ageInTicks);
            this.applyStatic(EnchanterAnimation.ENCHANTER_NO_ARM);
        }
        this.animateWalk(EnchanterAnimation.ENCHANTER_WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
    }

    public ModelPart root() {
        return this.realRoot;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

