/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.render.layer;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.client.ModModelLayers;
import baguchan.enchantwithmob.client.model.EnchantedWindModel;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EnchantedWindLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation WIND_TEXTURE_LOCATION = new ResourceLocation("textures/entity/breeze/breeze_wind.png");
    private static final float TOP_PART_ALPHA = 1.0f;
    private static final float MIDDLE_PART_ALPHA = 1.0f;
    private static final float BOTTOM_PART_ALPHA = 1.0f;
    private final EnchantedWindModel<T> model;

    public EnchantedWindLayer(RenderLayerParent<T, M> p_312625_, EntityModelSet p_312909_) {
        super(p_312625_);
        this.model = new EnchantedWindModel(p_312909_.bakeLayer(ModModelLayers.ENCHANTED_WIND));
    }

    public void render(PoseStack p_312822_, MultiBufferSource p_312869_, int p_311783_, T p_312046_, float p_312170_, float p_311773_, float p_312428_, float p_312287_, float p_312118_, float p_312531_) {
        IEnchantCap cap;
        if (p_312046_ instanceof IEnchantCap && (cap = (IEnchantCap)p_312046_).getEnchantCap().hasEnchant() && MobEnchantUtils.hasWindEnchant(cap.getEnchantCap().getMobEnchants())) {
            float f = (float)((LivingEntity)p_312046_).tickCount + p_312428_;
            this.model.prepareMobModel((Entity)p_312046_, p_312170_, p_311773_, p_312428_);
            VertexConsumer vertexconsumer = p_312869_.getBuffer(RenderType.breezeWind((ResourceLocation)this.getTextureLocation(p_312046_), (float)(this.xOffset(f) % 1.0f), (float)0.0f));
            this.model.setupAnim(p_312046_, p_312170_, p_311773_, p_312287_, p_312118_, p_312531_);
            this.model.windTop().skipDraw = true;
            this.model.windMiddle().skipDraw = true;
            this.model.windBottom().skipDraw = false;
            this.model.root().render(p_312822_, vertexconsumer, p_311783_, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.windTop().skipDraw = true;
            this.model.windMiddle().skipDraw = false;
            this.model.windBottom().skipDraw = true;
            this.model.root().render(p_312822_, vertexconsumer, p_311783_, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            this.model.windTop().skipDraw = false;
            this.model.windMiddle().skipDraw = true;
            this.model.windBottom().skipDraw = true;
            this.model.root().render(p_312822_, vertexconsumer, p_311783_, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private float xOffset(float p_312086_) {
        return p_312086_ * 0.02f;
    }

    protected ResourceLocation getTextureLocation(T p_312458_) {
        return WIND_TEXTURE_LOCATION;
    }
}

