/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mixin;

import bagu_chan.bagus_lib.api.IBaguPacket;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, remap=false)
public abstract class LivingEntityMixin
extends Entity
implements IEnchantCap,
IBaguPacket {
    public MobEnchantCapability capability = new MobEnchantCapability();

    public LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.put("MobEnchantData", (Tag)this.getEnchantCap().serializeNBT());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        MobEnchantCapability mobEnchantCapability = new MobEnchantCapability();
        mobEnchantCapability.deserializeNBT(nbt.getCompound("MobEnchantData"));
        this.setEnchantCap(mobEnchantCapability);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo callbackInfo) {
        if ((this.getEnchantCap().hasOwner() || this.getEnchantCap().isFromOwner()) && this.getEnchantCap().hasEnchant()) {
            if (this.getEnchantCap().getEnchantOwner() == null || !this.getEnchantCap().getEnchantOwner().isAlive()) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.playSound(SoundEvents.ITEM_BREAK, 1.5f, 1.6f);
            } else if (this.distanceToSqr((Entity)this.getEnchantCap().getEnchantOwner()) > 512.0) {
                LivingEntity livingEntity = (LivingEntity)this;
                this.getEnchantCap().removeMobEnchantFromOwner(livingEntity);
                this.playSound(SoundEvents.ITEM_BREAK, 1.5f, 1.6f);
            }
        }
    }

    public void resync(Entity entity) {
        if (!this.level().isClientSide) {
            for (int i = 0; i < this.getEnchantCap().getMobEnchants().size(); ++i) {
                MobEnchantedMessage message = new MobEnchantedMessage(this, this.getEnchantCap().getMobEnchants().get(i));
                PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)this).send(new CustomPacketPayload[]{message});
            }
        }
    }

    @Override
    public MobEnchantCapability getEnchantCap() {
        return this.capability;
    }

    @Override
    public void setEnchantCap(MobEnchantCapability cap) {
        this.capability = cap;
    }

    @Inject(method={"getVoicePitch"}, at={@At(value="RETURN")}, cancellable=true)
    public void getVoicePitch(CallbackInfoReturnable<Float> cir) {
        int fastTime = Mth.clamp((int)MobEnchantUtils.getMobEnchantLevelFromHandler(this.getEnchantCap().getMobEnchants(), MobEnchants.HASTE.get()), (int)0, (int)2);
        int slowTime = Mth.clamp((int)MobEnchantUtils.getMobEnchantLevelFromHandler(this.getEnchantCap().getMobEnchants(), MobEnchants.SLOW.get()), (int)0, (int)2);
        float different = Mth.clamp((float)(((Float)cir.getReturnValue()).floatValue() + (float)fastTime * 0.125f - (float)slowTime * 0.125f), (float)0.1f, (float)2.0f);
        cir.setReturnValue((Object)Float.valueOf(different));
    }

    @Shadow
    public boolean isBaby() {
        return false;
    }
}

