/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mixin;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.api.IEnchantedTime;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class}, remap=false)
public abstract class ServerLevelMixin
extends Level {
    protected ServerLevelMixin(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, Supplier<ProfilerFiller> p_270692_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        super(p_270739_, p_270683_, p_270200_, p_270240_, p_270692_, p_270904_, p_270470_, p_270248_, p_270466_);
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;tickCount:I", opcode=181)}, cancellable=true)
    public void tickNonPassenger(Entity instance, CallbackInfo ci) {
        if (instance instanceof IEnchantCap) {
            IEnchantCap enchantCap = (IEnchantCap)instance;
            if (instance instanceof IEnchantedTime) {
                int slowTime;
                IEnchantedTime enchantedTime = (IEnchantedTime)instance;
                int fastTime = Mth.clamp((int)MobEnchantUtils.getMobEnchantLevelFromHandler(enchantCap.getEnchantCap().getMobEnchants(), MobEnchants.HASTE.get()), (int)0, (int)2);
                float different = 1.0f + (float)fastTime * 0.125f - (float)(slowTime = Mth.clamp((int)MobEnchantUtils.getMobEnchantLevelFromHandler(enchantCap.getEnchantCap().getMobEnchants(), MobEnchants.SLOW.get()), (int)0, (int)2)) * 0.125f;
                if (different > 1.0f || different < 1.0f) {
                    enchantedTime.setDifferentTime(enchantedTime.getDifferentTime() + different);
                    --instance.tickCount;
                    ProfilerFiller profilerfiller = this.getProfiler();
                    while (enchantedTime.getDifferentTime() >= 1.0f) {
                        ++instance.tickCount;
                        this.getProfiler().push(() -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)instance.getType()).toString());
                        profilerfiller.incrementCounter("tickNonPassenger");
                        instance.tick();
                        this.getProfiler().pop();
                        enchantedTime.setDifferentTime(enchantedTime.getDifferentTime() - 1.0f);
                    }
                    for (Entity entity : instance.getPassengers()) {
                        this.tickPassenger(instance, entity);
                    }
                    ci.cancel();
                } else {
                    enchantedTime.setDifferentTime(0.0f);
                }
            }
        }
    }

    @Shadow
    private void tickPassenger(Entity p_8663_, Entity p_8664_) {
    }
}

