/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.api.IEnchantVisual;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.item.mobenchant.ItemMobEnchantments;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantCombatRules;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onTraceableEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantVisual) {
            TraceableEntity traceableEntity;
            Entity entity2;
            IEnchantVisual enchantVisual = (IEnchantVisual)entity;
            entity = event.getEntity();
            if (entity instanceof TraceableEntity && (entity2 = (traceableEntity = (TraceableEntity)entity).getOwner()) instanceof IEnchantCap) {
                IEnchantCap enchantCap = (IEnchantCap)entity2;
                enchantVisual.setEnchantVisual(enchantCap.getEnchantCap().hasEnchant());
            }
        }
    }

    @SubscribeEvent
    public static void onEnderDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            entity = event.getEntity();
            if (entity instanceof EnderDragon) {
                EnderDragon livingEntity = (EnderDragon)entity;
                Level world = event.getLevel();
                if (!world.isClientSide() && !cap.getEnchantCap().hasEnchant()) {
                    float difficultScale;
                    int i;
                    if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                        switch (world.getDifficulty()) {
                            case EASY: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)30.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(15)) * difficultScale), (float)1.0f, (float)60.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(20)) * difficultScale), (float)1.0f, (float)100.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                            }
                        }
                        livingEntity.setHealth(livingEntity.getMaxHealth());
                    }
                    if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                        switch (world.getDifficulty()) {
                            case EASY: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                            }
                        }
                        livingEntity.setHealth(livingEntity.getMaxHealth());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)mob;
            ServerLevelAccessor world = event.getLevel();
            if (!world.isClientSide()) {
                float difficultScale;
                int i;
                Mob livingEntity = event.getEntity();
                if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                    i = 0;
                    difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                    switch (world.getDifficulty()) {
                        case EASY: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)30.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(15)) * difficultScale), (float)1.0f, (float)60.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(20)) * difficultScale), (float)1.0f, (float)100.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, true);
                        }
                    }
                    livingEntity.setHealth(livingEntity.getMaxHealth());
                }
                if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                    i = 0;
                    difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                    switch (world.getDifficulty()) {
                        case EASY: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, false, false);
                        }
                    }
                    livingEntity.setHealth(livingEntity.getMaxHealth());
                }
                if (((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && CommonEventHandler.isSpawnEnchantableEntity((Entity)event.getEntity()) && (!(livingEntity instanceof Animal) && !(livingEntity instanceof WaterAnimal) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue())) {
                    if (event.getSpawnType() != MobSpawnType.BREEDING && event.getSpawnType() != MobSpawnType.CONVERSION && event.getSpawnType() != MobSpawnType.STRUCTURE && event.getSpawnType() != MobSpawnType.MOB_SUMMONED && (double)world.getRandom().nextFloat() < (Double)EnchantConfig.COMMON.difficultyBasePercent.get() * (double)world.getDifficulty().getId() + (double)world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() * (Double)EnchantConfig.COMMON.effectiveBasePercent.get() && !world.isClientSide()) {
                        i = 0;
                        difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                        switch (world.getDifficulty()) {
                            case EASY: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, true, false);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, true, false);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true, true, false);
                            }
                        }
                        livingEntity.setHealth(livingEntity.getMaxHealth());
                    }
                    if (event.getSpawnType() == MobSpawnType.TRIAL_SPAWNER && (double)world.getRandom().nextFloat() < 1.0) {
                        MobEnchantUtils.addEnchantmentToEntity((LivingEntity)livingEntity, cap, new MobEnchantmentData((MobEnchant)MobEnchants.WIND.get(), 1));
                    }
                }
            }
        }
    }

    private static boolean isSpawnAlwayEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    private static boolean isSpawnAlwayEnchantableAncientEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_ANCIENT_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    private static boolean isSpawnEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && !((List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (MobEnchantHandler enchantHandler : cap.getEnchantCap().getMobEnchants()) {
                    enchantHandler.getMobEnchant().tick(livingEntity, enchantHandler.getEnchantLevel());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().getEntity() instanceof LivingEntity && (attacker = (LivingEntity)event.getSource().getEntity()) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)attacker;
            if (cap.getEnchantCap().hasEnchant()) {
                int mobEnchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get());
                int mobEnchantSize = cap.getEnchantCap().getMobEnchants().size();
                if (!livingEntity.isDamageSourceBlocked(event.getSource()) && event.getAmount() == 0.0f) {
                    event.setAmount(MobEnchantCombatRules.getDamageAddition(1.0f, mobEnchantLevel, mobEnchantSize));
                } else if (event.getAmount() > 0.0f) {
                    event.setAmount(MobEnchantCombatRules.getDamageAddition(event.getAmount(), mobEnchantLevel, mobEnchantSize));
                }
            }
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get())) {
                int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.POISON.get());
                if (event.getAmount() > 0.0f && attacker.getRandom().nextFloat() < (float)i * 0.125f) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 60 * i, 0), (Entity)attacker);
                }
            }
        }
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            if (!event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS) && cap.getEnchantCap().hasEnchant()) {
                int mobEnchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get());
                int mobEnchantSize = cap.getEnchantCap().getMobEnchants().size();
                event.setAmount(MobEnchantCombatRules.getDamageReduction(event.getAmount(), mobEnchantLevel, mobEnchantSize));
            }
            if (event.getSource().getDirectEntity() != null && cap.getEnchantCap().hasEnchant()) {
                int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
                if (event.getSource().getDirectEntity() instanceof LivingEntity && !event.getSource().is(DamageTypeTags.IS_PROJECTILE) && !event.getSource().is(DamageTypes.THORNS) && livingEntity.getRandom().nextFloat() < (float)i * 0.1f) {
                    LivingEntity attacker2 = (LivingEntity)event.getSource().getDirectEntity();
                    attacker2.hurt(livingEntity.damageSources().thorns((Entity)livingEntity), MobEnchantCombatRules.getThornDamage(event.getAmount(), cap.getEnchantCap()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        if (!(entityTarget instanceof Player)) {
            IEnchantCap cap;
            LivingEntity target;
            if (stack.getItem() == ModItems.MOB_ENCHANT_BOOK.get() && !event.getEntity().getCooldowns().isOnCooldown(stack.getItem()) && entityTarget instanceof LivingEntity) {
                target = (LivingEntity)entityTarget;
                if (MobEnchantUtils.hasMobEnchant(stack) && target instanceof IEnchantCap) {
                    cap = (IEnchantCap)target;
                    boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, target, (LivingEntity)event.getEntity(), cap);
                    if (flag) {
                        event.getEntity().playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
                        stack.hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                        event.getEntity().getCooldowns().addCooldown(stack.getItem(), 60);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    } else {
                        event.getEntity().displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.enchant"), true);
                        event.getEntity().getCooldowns().addCooldown(stack.getItem(), 20);
                        event.setCancellationResult(InteractionResult.FAIL);
                        event.setCanceled(true);
                    }
                }
            }
            if (stack.getItem() == ModItems.MOB_UNENCHANT_BOOK.get() && !event.getEntity().getCooldowns().isOnCooldown(stack.getItem()) && entityTarget instanceof LivingEntity && (target = (LivingEntity)entityTarget) instanceof IEnchantCap) {
                cap = (IEnchantCap)target;
                MobEnchantUtils.removeMobEnchantToEntity(target, cap);
                event.getEntity().playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
                stack.hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                event.getEntity().getCooldowns().addCooldown(stack.getItem(), 80);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack stack3 = event.getLeft();
        int i = 0;
        long j = 0L;
        int k = 0;
        if (!stack3.isEmpty() && MobEnchantUtils.canStoreEnchantments(stack3)) {
            ItemStack stack1 = stack3.copy();
            ItemStack stack2 = event.getRight();
            ItemMobEnchantments.Mutable itemenchantments$mutable = new ItemMobEnchantments.Mutable(MobEnchantUtils.getEnchantmentsForCrafting(stack1));
            j += (long)((Integer)stack3.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue() + (long)((Integer)stack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
            boolean flag = false;
            if (!stack2.isEmpty()) {
                flag = stack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (stack1.isDamageableItem() && stack1.getItem().isValidRepairItem(stack3, stack2)) {
                    int j3;
                    int l2 = Math.min(stack1.getDamageValue(), stack1.getMaxDamage() / 4);
                    if (l2 <= 0) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setCost(0L);
                        return;
                    }
                    for (j3 = 0; l2 > 0 && j3 < stack2.getCount(); ++j3) {
                        int k3 = stack1.getDamageValue() - l2;
                        stack1.setDamageValue(k3);
                        ++i;
                        l2 = Math.min(stack1.getDamageValue(), stack1.getMaxDamage() / 4);
                    }
                    event.setMaterialCost(j3);
                } else {
                    if (!(flag || stack1.is(stack2.getItem()) && stack1.isDamageableItem())) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setCost(0L);
                        return;
                    }
                    if (stack1.isDamageableItem() && !flag) {
                        int l = stack3.getMaxDamage() - stack3.getDamageValue();
                        int i1 = stack2.getMaxDamage() - stack2.getDamageValue();
                        int j1 = i1 + stack1.getMaxDamage() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = stack1.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < stack1.getDamageValue()) {
                            stack1.setDamageValue(l1);
                            i += 2;
                        }
                    }
                    ItemMobEnchantments itemenchantments = MobEnchantUtils.getEnchantmentsForCrafting(stack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Object2IntMap.Entry<Holder<MobEnchant>> entry : itemenchantments.entrySet()) {
                        int j2;
                        Holder holder = (Holder)entry.getKey();
                        MobEnchant enchantment = (MobEnchant)holder.value();
                        int i2 = itemenchantments$mutable.getLevel(enchantment);
                        j2 = i2 == (j2 = entry.getIntValue()) ? j2 + 1 : Math.max(j2, i2);
                        boolean flag1 = true;
                        if (event.getPlayer().getAbilities().instabuild || stack3.is(ModItems.MOB_ENCHANT_BOOK.get()) || stack3.is(ModItems.ENCHANTERS_BOOK.get())) {
                            flag1 = true;
                        }
                        for (Holder<MobEnchant> holder1 : itemenchantments$mutable.keySet()) {
                            if (holder1.equals((Object)holder) || enchantment.isCompatibleWith((MobEnchant)holder1.value())) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (j2 > enchantment.getMaxLevel()) {
                            j2 = enchantment.getMaxLevel();
                        }
                        itemenchantments$mutable.set(enchantment, j2);
                        int l3 = enchantment.getAnvilCost();
                        if (flag) {
                            l3 = Math.max(1, l3 / 2);
                        }
                        i += l3 * j2;
                        if (stack3.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag3 && !flag2) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setCost(0L);
                        return;
                    }
                }
            }
            int k2 = (int)Mth.clamp((long)(j + (long)i), (long)0L, (long)Integer.MAX_VALUE);
            event.setCost((long)k2);
            if (i <= 0) {
                stack1 = ItemStack.EMPTY;
            }
            if (k == i && k > 0 && event.getCost() >= 40L) {
                event.setCost(39L);
            }
            if (event.getCost() >= 40L && !event.getPlayer().getAbilities().instabuild) {
                stack1 = ItemStack.EMPTY;
            }
            if (!stack1.isEmpty()) {
                int i3 = (Integer)stack1.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                if (i3 < (Integer)stack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
                    i3 = (Integer)stack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                }
                if (k != i || k == 0) {
                    i3 = AnvilMenu.calculateIncreasedRepairCost((int)i3);
                }
                stack1.set(DataComponents.REPAIR_COST, (Object)i3);
                MobEnchantUtils.setEnchantments(stack1, itemenchantments$mutable.toImmutable());
            }
            event.setOutput(stack1);
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        IEnchantCap cap;
        LivingEntity entity = event.getEntity();
        if (entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            if (cap.getEnchantCap().isAncient()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap) * 5);
            } else {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player instanceof IEnchantCap) {
                IEnchantCap cap = (IEnchantCap)player;
                for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MobEnchantedMessage((Entity)player, cap.getEnchantCap().getMobEnchants().get(i)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerEntity;
            if (!playerEntity.level().isClientSide()) {
                for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)playerEntity, (CustomPacketPayload)new MobEnchantedMessage((Entity)playerEntity, cap.getEnchantCap().getMobEnchants().get(i)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath()) {
            ((IEnchantCap)oldPlayer).getEnchantCap().getMobEnchants().forEach(mobEnchantHandler -> ((IEnchantCap)newPlayer).getEnchantCap().addMobEnchant((LivingEntity)newPlayer, mobEnchantHandler.getMobEnchant(), mobEnchantHandler.getEnchantLevel()));
        }
    }
}

