/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.entity;

import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnchanterEntity
extends SpellcasterIllager {
    private LivingEntity enchantTarget;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState castingAnimationState = new AnimationState();
    public int attackAnimationTick;
    public final int attackAnimationLength = 19;
    public final int attackAnimationActionPoint = 10;
    public int castingAnimationTick;
    public final int castingAnimationLength = 72;

    public EnchanterEntity(EntityType<? extends EnchanterEntity> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
        this.xpReward = 12;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CastingSpellGoal());
        this.goalSelector.addGoal(1, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(3, new AvoidTargetEntityGoal<Mob>(this, Mob.class, 6.5f, 0.8, 1.05));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.15));
        this.goalSelector.addGoal(4, (Goal)new SpellGoal());
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.stop();
            }
            if (this.castingAnimationTick < this.castingAnimationLength) {
                ++this.castingAnimationTick;
            }
            if (this.castingAnimationTick >= this.castingAnimationLength) {
                this.castingAnimationState.stop();
            }
        }
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 4) {
            this.attackAnimationState.start(this.tickCount);
            this.idleAnimationState.stop();
            this.castingAnimationState.stop();
            this.attackAnimationTick = 0;
        } else if (p_21375_ == 61) {
            this.castingAnimationState.start(this.tickCount);
            this.idleAnimationState.stop();
            this.attackAnimationState.stop();
            this.castingAnimationTick = 0;
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    public static AttributeSupplier.Builder createAttributeMap() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.attackAnimationState.isStarted() || this.castingAnimationState.isStarted() || this.hurtTime > 0 || this.walkAnimation.isMoving()) {
            this.idleAnimationState.stop();
        } else {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    private void setEnchantTarget(@Nullable LivingEntity enchantTargetIn) {
        this.enchantTarget = enchantTargetIn;
    }

    @Nullable
    public LivingEntity getEnchantTarget() {
        return this.enchantTarget;
    }

    protected void dropCustomDeathLoot(DamageSource source, int looting, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(source, looting, recentlyHitIn);
        if (this.random.nextFloat() < 0.25f + 0.025f * (float)looting) {
            if (this.raid != null && this.hasActiveRaid() && this.getWave() > 0) {
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
                if (this.random.nextFloat() < 0.5f) {
                    itemStack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
                }
                this.spawnAtLocation(MobEnchantUtils.addRandomEnchantmentToItemStack(this.random, itemStack, 20 + this.getWave() * 4, true, false));
            } else {
                ItemStack itemStack = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
                if (this.random.nextFloat() < 0.5f) {
                    itemStack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
                }
                this.spawnAtLocation(MobEnchantUtils.addRandomEnchantmentToItemStack(this.random, itemStack, 20, true, false));
            }
        }
    }

    public boolean canBeLeader() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ILLUSIONER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ILLUSIONER_HURT;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.ENCHANTMENT_TABLE_USE;
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    public void applyRaidBuffs(int p_213660_1_, boolean p_213660_2_) {
        EnchanterEntity enchanterEntity;
        boolean flag;
        Raid raid = this.getCurrentRaid();
        boolean bl = flag = this.random.nextFloat() <= raid.getEnchantOdds() + 0.1f;
        if (flag && (enchanterEntity = this) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)((Object)enchanterEntity);
            MobEnchantUtils.addEnchantmentToEntity((LivingEntity)this, cap, new MobEnchantmentData((MobEnchant)MobEnchants.PROTECTION.get(), 2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
        }

        public void tick() {
            if (EnchanterEntity.this.isCastingSpell() && EnchanterEntity.this.getEnchantTarget() != null) {
                EnchanterEntity.this.getLookControl().setLookAt((Entity)EnchanterEntity.this.getEnchantTarget(), (float)EnchanterEntity.this.getMaxHeadYRot(), (float)EnchanterEntity.this.getMaxHeadXRot());
            } else if (EnchanterEntity.this.isCastingSpell() && EnchanterEntity.this.getTarget() != null) {
                EnchanterEntity.this.getLookControl().setLookAt((Entity)EnchanterEntity.this.getTarget(), (float)EnchanterEntity.this.getMaxHeadYRot(), (float)EnchanterEntity.this.getMaxHeadXRot());
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final EnchanterEntity enchanter;
        private int tick;

        AttackGoal(EnchanterEntity enchanter) {
            this.enchanter = enchanter;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.enchanter.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return this.canPerformAttack(livingentity);
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.tick < 20;
        }

        public void start() {
            super.start();
            this.enchanter.level().broadcastEntityEvent((Entity)this.enchanter, (byte)4);
        }

        public void stop() {
            super.stop();
            this.tick = 0;
        }

        public void tick() {
            super.tick();
            LivingEntity livingentity = this.enchanter.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                this.enchanter.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                if (this.canPerformAttack(livingentity)) {
                    if (this.tick == this.enchanter.attackAnimationActionPoint) {
                        this.enchanter.swing(InteractionHand.MAIN_HAND);
                        this.enchanter.doHurtTarget((Entity)livingentity);
                        this.enchanter.playSound(SoundEvents.ILLUSIONER_AMBIENT);
                    }
                    this.enchanter.getNavigation().stop();
                }
            }
            ++this.tick;
        }

        protected boolean canPerformAttack(LivingEntity p_301299_) {
            return this.enchanter.isWithinMeleeAttackRange(p_301299_) && this.enchanter.getSensing().hasLineOfSight((Entity)p_301299_);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    class AvoidTargetEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final EnchanterEntity enchanter;

        public AvoidTargetEntityGoal(EnchanterEntity enchanterIn, Class<T> entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super((PathfinderMob)enchanterIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
            this.enchanter = enchanterIn;
        }

        public boolean canUse() {
            if (super.canUse() && this.toAvoid == this.enchanter.getTarget()) {
                return this.enchanter.getTarget() != null;
            }
            return false;
        }

        public void start() {
            EnchanterEntity.this.setTarget(null);
            super.start();
        }

        public void tick() {
            EnchanterEntity.this.setTarget(null);
            super.tick();
        }
    }

    public class SpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final Predicate<LivingEntity> fillter;
        private final Predicate<LivingEntity> enchanted_fillter;

        public SpellGoal() {
            super((SpellcasterIllager)EnchanterEntity.this);
            this.fillter = entity -> {
                IEnchantCap enchantCap;
                return !(entity instanceof EnchanterEntity) && entity instanceof IEnchantCap && !(enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
            };
            this.enchanted_fillter = entity -> {
                IEnchantCap enchantCap;
                return !(entity instanceof EnchanterEntity) && entity instanceof IEnchantCap && (enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
            };
        }

        public boolean canUse() {
            if (EnchanterEntity.this.getTarget() == null) {
                return false;
            }
            if (EnchanterEntity.this.isCastingSpell()) {
                return false;
            }
            if (EnchanterEntity.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            List list = EnchanterEntity.this.level().getEntitiesOfClass(LivingEntity.class, EnchanterEntity.this.getBoundingBox().expandTowards(16.0, 8.0, 16.0), this.fillter);
            if (list.isEmpty()) {
                return false;
            }
            List enchanted_list = EnchanterEntity.this.level().getEntitiesOfClass(LivingEntity.class, EnchanterEntity.this.getBoundingBox().expandTowards(16.0, 8.0, 16.0), this.enchanted_fillter);
            if (enchanted_list.size() < 5) {
                LivingEntity target = (LivingEntity)list.get(EnchanterEntity.this.random.nextInt(list.size()));
                if (target != EnchanterEntity.this.getTarget() && target != EnchanterEntity.this && target.isAlliedTo((Entity)EnchanterEntity.this) && EnchanterEntity.this.isAlliedTo((Entity)target) && (target.getTeam() == EnchanterEntity.this.getTeam() || target.getType().is(EntityTypeTags.ILLAGER_FRIENDS) && target.getTeam() == null)) {
                    EnchanterEntity.this.setEnchantTarget(target);
                    EnchanterEntity.this.level().broadcastEntityEvent((Entity)EnchanterEntity.this, (byte)61);
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return EnchanterEntity.this.getEnchantTarget() != null && EnchanterEntity.this.getEnchantTarget() != EnchanterEntity.this.getTarget() && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            EnchanterEntity.this.setEnchantTarget(null);
        }

        protected void performSpellCasting() {
            LivingEntity entity = EnchanterEntity.this.getEnchantTarget();
            if (entity != null && entity.isAlive() && entity instanceof IEnchantCap) {
                IEnchantCap cap = (IEnchantCap)entity;
                MobEnchantUtils.addUnstableRandomEnchantmentToEntity(entity, (LivingEntity)EnchanterEntity.this, cap, entity.getRandom(), 12, false, false);
            }
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 200;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.BOOK_PAGE_TURN;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

