/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.item;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.client.ModModelLayers;
import baguchan.enchantwithmob.client.model.EnchanterClothesModel;
import baguchan.enchantwithmob.registry.ModArmorMaterials;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchanterClothesItem
extends ArmorItem {
    public static final ResourceLocation TEXTURE = new ResourceLocation("enchantwithmob", "textures/models/armor/enchanter_clothes.png");

    public EnchanterClothesItem(ArmorItem.Type type, Item.Properties p_40388_) {
        super(ModArmorMaterials.ENCHANTER_CLOTHES, type, p_40388_);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ArmorRender.INSTANCE);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return TEXTURE;
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableEnchanterArmor.get() == false;
    }

    private static final class ArmorRender
    implements IClientItemExtensions {
        private static final ArmorRender INSTANCE = new ArmorRender();

        private ArmorRender() {
        }

        @NotNull
        public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            EntityModelSet models = Minecraft.getInstance().getEntityModels();
            ModelPart root = models.bakeLayer(ModModelLayers.ENCHANTER_CLOTHES);
            EnchanterClothesModel model2 = new EnchanterClothesModel(root);
            ClientHooks.copyModelProperties(original, model2);
            model2.rightBoots.copyFrom(model2.rightLeg);
            model2.leftBoots.copyFrom(model2.leftLeg);
            this.setPartVisibility(model2, equipmentSlot);
            return model2;
        }

        protected void setPartVisibility(EnchanterClothesModel p_117126_, EquipmentSlot p_117127_) {
            p_117126_.setAllVisible(false);
            switch (p_117127_) {
                case HEAD: {
                    p_117126_.head.visible = true;
                    p_117126_.hat.visible = true;
                    break;
                }
                case CHEST: {
                    p_117126_.body.visible = true;
                    p_117126_.rightArm.visible = true;
                    p_117126_.leftArm.visible = true;
                    break;
                }
                case LEGS: {
                    p_117126_.rightLeg.visible = true;
                    p_117126_.leftLeg.visible = true;
                    break;
                }
                case FEET: {
                    p_117126_.rightBoots.visible = true;
                    p_117126_.leftBoots.visible = true;
                }
            }
        }
    }
}

