/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.item;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MobUnEnchantBookItem
extends Item {
    public MobUnEnchantBookItem(Item.Properties group) {
        super(group);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        IEnchantCap cap;
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn instanceof IEnchantCap && !(cap = (IEnchantCap)playerIn).getEnchantCap().isAncient()) {
            MobEnchantUtils.removeMobEnchantToEntity((LivingEntity)playerIn, cap);
        }
        playerIn.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
        stack.hurtAndBreak(1, (LivingEntity)playerIn, LivingEntity.getSlotForHand((InteractionHand)handIn));
        playerIn.getCooldowns().addCooldown(stack.getItem(), 80);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.appendHoverText(stack, level, tooltip, p_41424_);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        tooltip.add((Component)Component.translatable((String)"mobenchant.enchantwithmob.mob_unenchant_book.tooltip").withStyle(textformatting2));
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

