/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.message;

import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.api.IEnchantCap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class RemoveMobEnchantOwnerMessage
implements CustomPacketPayload,
IPayloadHandler<RemoveMobEnchantOwnerMessage> {
    public static final StreamCodec<FriendlyByteBuf, RemoveMobEnchantOwnerMessage> STREAM_CODEC = CustomPacketPayload.codec(RemoveMobEnchantOwnerMessage::write, RemoveMobEnchantOwnerMessage::new);
    public static final CustomPacketPayload.Type<RemoveMobEnchantOwnerMessage> TYPE = CustomPacketPayload.createType((String)EnchantWithMob.prefix("remove_mob_enchant_owner").toString());
    private int entityId;

    public RemoveMobEnchantOwnerMessage(Entity entity) {
        this.entityId = entity.getId();
    }

    public RemoveMobEnchantOwnerMessage(int id) {
        this.entityId = id;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    public RemoveMobEnchantOwnerMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void handle(RemoveMobEnchantOwnerMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            LivingEntity livingEntity;
            Entity entity = Minecraft.getInstance().player.level().getEntity(message.entityId);
            if (entity != null && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) instanceof IEnchantCap) {
                IEnchantCap cap = (IEnchantCap)livingEntity;
                cap.getEnchantCap().removeOwner(livingEntity);
            }
        });
    }
}

