/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.utils;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.item.mobenchant.ItemMobEnchantments;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModDataCompnents;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    public static void executeIfPresent(Entity entity, MobEnchant mobEnchantment, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && MobEnchantUtils.findMobEnchantFromHandler((cap = (IEnchantCap)entity).getEnchantCap().getMobEnchants(), mobEnchantment)) {
            runnable.run();
        }
    }

    public static boolean hasWindEnchant(List<MobEnchantHandler> list) {
        return MobEnchantUtils.findMobEnchantFromHandler(list, (MobEnchant)MobEnchants.WIND.get());
    }

    public static void executeIfPresent(Entity entity, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            runnable.run();
        }
    }

    @Nullable
    public static MobEnchant getEnchantFromNBT(@Nullable CompoundTag tag) {
        if (tag != null && MobEnchants.getRegistry().containsKey(ResourceLocation.tryParse((String)tag.getString(TAG_MOBENCHANT)))) {
            return (MobEnchant)MobEnchants.getRegistry().get(ResourceLocation.tryParse((String)tag.getString(TAG_MOBENCHANT)));
        }
        return null;
    }

    public static int getEnchantLevelFromNBT(@Nullable CompoundTag tag) {
        if (tag != null) {
            return tag.getInt(TAG_ENCHANT_LEVEL);
        }
        return 0;
    }

    @Nullable
    public static MobEnchant getEnchantFromString(@Nullable String id) {
        if (id != null && MobEnchants.getRegistry().containsKey(ResourceLocation.tryParse((String)id))) {
            return (MobEnchant)MobEnchants.getRegistry().get(ResourceLocation.tryParse((String)id));
        }
        return null;
    }

    @Nullable
    public static MobEnchant getEnchantFromResourceLocation(@Nullable ResourceLocation id) {
        if (id != null && MobEnchants.getRegistry().containsKey(id)) {
            return (MobEnchant)MobEnchants.getRegistry().get(id);
        }
        return null;
    }

    public static boolean hasMobEnchant(ItemStack stack) {
        @Nullable ItemMobEnchantments itemMobEnchantments = (ItemMobEnchantments)stack.get(ModDataCompnents.MOB_ENCHANTMENTS);
        return itemMobEnchantments != null;
    }

    public static ListTag getEnchantmentListForNBT(CompoundTag compoundnbt) {
        return compoundnbt != null ? compoundnbt.getList(TAG_STORED_MOBENCHANTS, 10) : new ListTag();
    }

    public static ItemMobEnchantments getEnchantmentsForCrafting(ItemStack stack) {
        return (ItemMobEnchantments)stack.getOrDefault((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), (Object)ItemMobEnchantments.EMPTY);
    }

    public static void setEnchantments(ItemStack stack, ItemMobEnchantments p_332148_) {
        stack.set((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), (Object)p_332148_);
    }

    public static boolean canStoreEnchantments(ItemStack p_330666_) {
        return p_330666_.has((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get());
    }

    public static void enchant(MobEnchant p_41664_, ItemStack stack, int p_41665_) {
        MobEnchantUtils.updateEnchantments(stack, p_330091_ -> p_330091_.upgrade(p_41664_, p_41665_));
    }

    public static ItemMobEnchantments updateEnchantments(ItemStack p_331034_, Consumer<ItemMobEnchantments.Mutable> p_332031_) {
        DataComponentType datacomponenttype = (DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get();
        ItemMobEnchantments itemenchantments = (ItemMobEnchantments)p_331034_.getOrDefault(datacomponenttype, (Object)ItemMobEnchantments.EMPTY);
        ItemMobEnchantments.Mutable itemenchantments$mutable = new ItemMobEnchantments.Mutable(itemenchantments);
        p_332031_.accept(itemenchantments$mutable);
        ItemMobEnchantments itemenchantments1 = itemenchantments$mutable.toImmutable();
        p_331034_.set(datacomponenttype, (Object)itemenchantments1);
        return itemenchantments1;
    }

    public static boolean addItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, LivingEntity user, IEnchantCap capability) {
        ItemMobEnchantments itemMobEnchantments = MobEnchantUtils.getEnchantmentsForCrafting(itemIn);
        boolean flag = false;
        for (Holder<MobEnchant> mobEnchant : itemMobEnchantments.keySet()) {
            int level = itemMobEnchantments.getLevel((MobEnchant)mobEnchant.value());
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob((MobEnchant)mobEnchant.value(), entity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(entity, (MobEnchant)mobEnchant.value(), level);
            flag = true;
            if (user.level().isClientSide()) continue;
            itemIn.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return flag;
    }

    public static boolean addUnstableItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, LivingEntity owner, IEnchantCap capability) {
        ItemMobEnchantments itemMobEnchantments = MobEnchantUtils.getEnchantmentsForCrafting(itemIn);
        boolean flag = false;
        for (Holder<MobEnchant> mobEnchant : itemMobEnchantments.keySet()) {
            int level = itemMobEnchantments.getLevel((MobEnchant)mobEnchant.value());
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob((MobEnchant)mobEnchant.value(), entity, capability)) continue;
            capability.getEnchantCap().addMobEnchantFromOwner(entity, (MobEnchant)mobEnchant.value(), level, owner);
            flag = true;
            if (owner.level().isClientSide()) continue;
            itemIn.hurtAndBreak(1, owner, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return flag;
    }

    public static void removeMobEnchantToEntity(LivingEntity entity, IEnchantCap capability) {
        capability.getEnchantCap().removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(IEnchantCap cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getEnchantCap().getMobEnchants()) {
            MobEnchant enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, false);
            flag = true;
        }
        return flag;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data, boolean ancient) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addRandomEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, RandomSource random, int level, boolean allowTresure, boolean allowCurse, boolean ancient) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowTresure, allowCurse);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addUnstableRandomEnchantmentToEntity(LivingEntity livingEntity, LivingEntity ownerEntity, IEnchantCap capability, RandomSource random, int level, boolean allowTresure, boolean allowCurse) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowTresure, allowCurse);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchantFromOwner(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ownerEntity);
            flag = true;
        }
        return flag;
    }

    public static ItemStack addRandomEnchantmentToItemStack(RandomSource random, ItemStack stack, int level, boolean allowRare, boolean allowCurse) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare, allowCurse);
        for (MobEnchantmentData enchantmentdata : list) {
            if (enchantmentdata.enchantment.isDisabled()) continue;
            MobEnchantUtils.enchant(enchantmentdata.enchantment, stack, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchantHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (!mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchant(List<MobEnchant> list, MobEnchant findMobEnchant) {
        return list.contains(findMobEnchant);
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || findMobEnchant.isDisabled() || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable MobEnchant mobEnchant, LivingEntity livingEntity, IEnchantCap capability) {
        if (!((Boolean)EnchantConfig.COMMON.universalEnchant.get()).booleanValue() && mobEnchant != null && !mobEnchant.isCompatibleMob(livingEntity)) {
            return false;
        }
        if (mobEnchant.isDisabled()) {
            return false;
        }
        for (MobEnchantHandler enchantHandler : capability.getEnchantCap().getMobEnchants()) {
            if (mobEnchant == null || enchantHandler.getMobEnchant() == null || enchantHandler.getMobEnchant().isCompatibleWith(mobEnchant)) continue;
            return false;
        }
        return mobEnchant != null;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(RandomSource randomIn, int level, boolean allowTresure, boolean allowCursed) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.makeMobEnchantmentDatas(level = Mth.clamp((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), allowTresure, allowCursed);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem((RandomSource)randomIn, list1).ifPresent(list::add);
            while (randomIn.nextInt(50) <= level) {
                if (!list.isEmpty()) {
                    MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)((Object)Util.lastOf((List)list)));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem((RandomSource)randomIn, list1).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> makeMobEnchantmentDatas(int p_185291_0_, boolean allowTresure, boolean allowCursed) {
        ArrayList list = Lists.newArrayList();
        block0: for (MobEnchant enchantment : MobEnchants.getRegistry()) {
            if (enchantment.isCursedEnchant() && !allowCursed || enchantment.isTresureEnchant() && !allowTresure || !enchantment.isDiscoverable()) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().enchantment) && !data.enchantment.isDisabled()) continue;
            iterator.remove();
        }
    }
}

