/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.dialog;

import bagu_chan.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ImageDialogType
extends DialogType {
    @Nullable
    protected ResourceLocation resourceLocation;
    protected int sizeX = 32;
    protected int sizeY = 32;

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount) {
        if (this.resourceLocation != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)this.renderDialogY, 0.0f);
            poseStack.scale(this.scaleX, this.scaleY, 1.0f);
            guiGraphics.blitSprite(this.resourceLocation, this.posX, this.posY, this.sizeX, this.sizeY);
            poseStack.popPose();
        }
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tag = super.writeTag();
        if (this.resourceLocation != null) {
            tag.putString("ImagePath", this.resourceLocation.toString());
        }
        tag.putInt("sizeX", this.sizeX);
        tag.putInt("sizeY", this.sizeY);
        return tag;
    }

    @Override
    public void readTag(CompoundTag tag) {
        super.readTag(tag);
        if (tag.contains("ImagePath")) {
            this.resourceLocation = ResourceLocation.tryParse((String)tag.getString("ImagePath"));
        }
        if (tag.contains("sizeX")) {
            this.sizeX = tag.getInt("sizeX");
        }
        if (tag.contains("sizeY")) {
            this.sizeY = tag.getInt("sizeY");
        }
    }

    public void setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public void setResourceLocation(@Nullable ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }
}

