/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.layer;

import bagu_chan.bagus_lib.client.layer.IArmor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Quaternionf;

public class CustomArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final HumanoidModel defaultBipedModel;
    private final HumanoidModel innerModel;
    private RenderLayerParent<T, M> renderer;
    private final TextureAtlas armorTrimAtlas;

    public CustomArmorLayer(RenderLayerParent<T, M> render, EntityRendererProvider.Context context) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.innerModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.renderer = render;
        this.armorTrimAtlas = context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    }

    public CustomArmorLayer(RenderLayerParent<T, M> render, EntityModelSet modelSet, ModelManager modelManager) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(modelSet.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.innerModel = new HumanoidModel(modelSet.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.renderer = render;
        this.armorTrimAtlas = modelManager.getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, ArmorMaterial.Layer material, EquipmentSlot slot, boolean usesInner) {
        ArmorItem item = (ArmorItem)stack.getItem();
        String texture = item.getMaterial().getRegisteredName();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        ResourceLocation s1 = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)stack, (ArmorMaterial.Layer)material, (boolean)usesInner, (EquipmentSlot)slot);
        return s1;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float f2;
        float f1;
        float f;
        int i;
        int clampedLight;
        boolean flag1;
        boolean notAVanillaModel;
        HumanoidModel<?> a;
        boolean flag;
        ArmorItem armoritem;
        matrixStackIn.pushPose();
        ItemStack headItem = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (headItem.getItem() instanceof ArmorItem) {
            armoritem = (ArmorItem)headItem.getItem();
            if (headItem.canEquip(EquipmentSlot.HEAD, (Entity)entity)) {
                for (ArmorMaterial.Layer armormaterial$layer : ((ArmorMaterial)armoritem.getMaterial().value()).layers()) {
                    flag = CustomArmorLayer.usesInnerModel(armoritem.getEquipmentSlot());
                    a = this.defaultBipedModel;
                    notAVanillaModel = (a = this.getArmorModelHook(entity, headItem, EquipmentSlot.HEAD, (HumanoidModel)a)) != this.defaultBipedModel;
                    this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                    flag1 = headItem.hasFoil();
                    clampedLight = packedLightIn;
                    if (headItem.is(ItemTags.DYEABLE)) {
                        i = DyedItemColor.getOrDefault((ItemStack)headItem, (int)-6265536);
                        f = (float)(i >> 16 & 0xFF) / 255.0f;
                        f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        f2 = (float)(i & 0xFF) / 255.0f;
                        this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, headItem, armormaterial$layer, EquipmentSlot.HEAD, flag), notAVanillaModel);
                        this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, headItem, armormaterial$layer, EquipmentSlot.HEAD, flag), notAVanillaModel);
                        continue;
                    }
                    this.renderHelmet(headItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, headItem, armormaterial$layer, EquipmentSlot.HEAD, flag), notAVanillaModel);
                }
            }
        } else {
            ((IArmor)this.renderer.getModel()).headPartArmors().forEach(part -> {
                ((IArmor)this.renderer.getModel()).translateToHead((ModelPart)part, matrixStackIn);
                matrixStackIn.translate(0.0, -0.25, 0.0);
                matrixStackIn.mulPose(new Quaternionf().rotateX((float)Math.PI));
                matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.PI));
                matrixStackIn.scale(0.625f, 0.625f, 0.625f);
                Minecraft.getInstance().getItemRenderer().renderStatic(headItem, ItemDisplayContext.HEAD, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, entity.level(), 0);
            });
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        ItemStack chestItem = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (chestItem.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)chestItem.getItem()).getEquipmentSlot() == EquipmentSlot.CHEST) {
            for (ArmorMaterial.Layer armormaterial$layer : ((ArmorMaterial)armoritem.getMaterial().value()).layers()) {
                flag = CustomArmorLayer.usesInnerModel(armoritem.getEquipmentSlot());
                a = this.defaultBipedModel;
                notAVanillaModel = (a = this.getArmorModelHook(entity, chestItem, EquipmentSlot.CHEST, (HumanoidModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible((HumanoidModel)a, EquipmentSlot.CHEST);
                flag1 = chestItem.hasFoil();
                clampedLight = packedLightIn;
                if (chestItem.is(ItemTags.DYEABLE)) {
                    i = DyedItemColor.getOrDefault((ItemStack)chestItem, (int)-6265536);
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, armormaterial$layer, EquipmentSlot.CHEST, flag), notAVanillaModel);
                    this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, armormaterial$layer, EquipmentSlot.CHEST, flag), notAVanillaModel);
                    continue;
                }
                this.renderChestplate(chestItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, chestItem, armormaterial$layer, EquipmentSlot.CHEST, flag), notAVanillaModel);
            }
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        ItemStack legItem = entity.getItemBySlot(EquipmentSlot.LEGS);
        if (legItem.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)legItem.getItem()).getEquipmentSlot() == EquipmentSlot.LEGS) {
            for (ArmorMaterial.Layer armormaterial$layer : ((ArmorMaterial)armoritem.getMaterial().value()).layers()) {
                flag = CustomArmorLayer.usesInnerModel(armoritem.getEquipmentSlot());
                a = this.innerModel;
                notAVanillaModel = (a = this.getArmorModelHook(entity, legItem, EquipmentSlot.LEGS, (HumanoidModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible((HumanoidModel)a, EquipmentSlot.LEGS);
                flag1 = legItem.hasFoil();
                clampedLight = packedLightIn;
                if (legItem.is(ItemTags.DYEABLE)) {
                    i = DyedItemColor.getOrDefault((ItemStack)legItem, (int)-6265536);
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, legItem, armormaterial$layer, EquipmentSlot.LEGS, flag), notAVanillaModel);
                    this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, legItem, armormaterial$layer, EquipmentSlot.LEGS, flag), notAVanillaModel);
                    continue;
                }
                this.renderLeg(legItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, legItem, armormaterial$layer, EquipmentSlot.LEGS, flag), notAVanillaModel);
            }
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        ItemStack feetItem = entity.getItemBySlot(EquipmentSlot.FEET);
        if (feetItem.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)feetItem.getItem()).getEquipmentSlot() == EquipmentSlot.FEET) {
            for (ArmorMaterial.Layer armormaterial$layer : ((ArmorMaterial)armoritem.getMaterial().value()).layers()) {
                flag = CustomArmorLayer.usesInnerModel(armoritem.getEquipmentSlot());
                a = this.defaultBipedModel;
                notAVanillaModel = (a = this.getArmorModelHook(entity, feetItem, EquipmentSlot.FEET, (HumanoidModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.FEET);
                flag1 = feetItem.hasFoil();
                clampedLight = packedLightIn;
                if (feetItem.is(ItemTags.DYEABLE)) {
                    i = DyedItemColor.getOrDefault((ItemStack)feetItem, (int)-6265536);
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, armormaterial$layer, EquipmentSlot.FEET, flag), notAVanillaModel);
                    this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, armormaterial$layer, EquipmentSlot.FEET, flag), notAVanillaModel);
                    continue;
                }
                this.renderBoot(feetItem, entity, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, CustomArmorLayer.getArmorResource((Entity)entity, feetItem, armormaterial$layer, EquipmentSlot.FEET, flag), notAVanillaModel);
            }
        }
        matrixStackIn.popPose();
    }

    private static boolean usesInnerModel(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    private HumanoidModel getArmorModel(EquipmentSlot p_117079_) {
        return CustomArmorLayer.usesInnerModel(p_117079_) ? this.innerModel : this.defaultBipedModel;
    }

    private void renderTrim(ModelPart part, Holder<ArmorMaterial> p_267946_, PoseStack p_268019_, MultiBufferSource p_268023_, int p_268190_, ArmorTrim p_267984_, boolean p_267965_, HumanoidModel p_267949_, boolean p_268259_, float p_268337_, float p_268095_, float p_268305_) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.getSprite(p_268259_ ? p_267984_.innerTexture(p_267946_) : p_267984_.outerTexture(p_267946_));
        VertexConsumer vertexconsumer = textureatlassprite.wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)p_268023_, (RenderType)Sheets.armorTrimsSheet((boolean)((TrimPattern)p_267984_.pattern().value()).decal()), (boolean)true, (boolean)p_267965_));
        part.render(p_268019_, vertexconsumer, p_268190_, OverlayTexture.NO_OVERLAY, p_268337_, p_268095_, p_268305_, 1.0f);
    }

    private void renderTrim(ModelPart part, ItemStack item, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, EquipmentSlot equipmentSlot, HumanoidModel modelIn) {
        Item item2 = item.getItem();
        if (item2 instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item2;
            ArmorTrim armortrim = (ArmorTrim)item.get(DataComponents.TRIM);
            if (armortrim != null) {
                this.renderTrim(part, (Holder<ArmorMaterial>)armorItem.getMaterial(), matrixStackIn, bufferIn, packedLightIn, armortrim, glintIn, modelIn, CustomArmorLayer.usesInnerModel(equipmentSlot), 1.0f, 1.0f, 1.0f);
            }
        }
    }

    private void renderLeg(ItemStack legItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.getModel().copyPropertiesTo((EntityModel)modelIn);
        modelIn.body.xRot = 0.0f;
        modelIn.body.yRot = 0.0f;
        modelIn.body.zRot = 0.0f;
        modelIn.body.x = 0.0f;
        modelIn.body.y = 0.0f;
        modelIn.body.z = 0.0f;
        modelIn.rightLeg.x = 0.0f;
        modelIn.rightLeg.xRot = 0.0f;
        modelIn.rightLeg.yRot = 0.0f;
        modelIn.rightLeg.zRot = 0.0f;
        modelIn.leftLeg.x = 0.0f;
        modelIn.leftLeg.xRot = 0.0f;
        modelIn.leftLeg.yRot = 0.0f;
        modelIn.leftLeg.zRot = 0.0f;
        modelIn.leftLeg.y = 0.0f;
        modelIn.rightLeg.y = 0.0f;
        modelIn.leftLeg.z = 0.0f;
        modelIn.rightLeg.z = 0.0f;
        ((IArmor)this.renderer.getModel()).rightLegPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.rightLeg.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.rightLeg, legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.popPose();
        });
        ((IArmor)this.renderer.getModel()).leftLegPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.leftLeg.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.leftLeg, legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.popPose();
        });
        ((IArmor)this.renderer.getModel()).bodyPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToChest((ModelPart)part, matrixStackIn);
            modelIn.body.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.body, legItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.LEGS, modelIn);
            matrixStackIn.popPose();
        });
    }

    private void renderBoot(ItemStack feetItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.getModel().copyPropertiesTo((EntityModel)modelIn);
        modelIn.rightLeg.x = 0.0f;
        modelIn.rightLeg.xRot = 0.0f;
        modelIn.rightLeg.yRot = 0.0f;
        modelIn.rightLeg.zRot = 0.0f;
        modelIn.leftLeg.x = 0.0f;
        modelIn.leftLeg.xRot = 0.0f;
        modelIn.leftLeg.yRot = 0.0f;
        modelIn.leftLeg.zRot = 0.0f;
        modelIn.leftLeg.y = 0.0f;
        modelIn.rightLeg.y = 0.0f;
        modelIn.leftLeg.z = 0.0f;
        modelIn.rightLeg.z = 0.0f;
        ((IArmor)this.renderer.getModel()).rightLegPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.rightLeg.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.rightLeg, feetItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.FEET, modelIn);
            matrixStackIn.popPose();
        });
        ((IArmor)this.renderer.getModel()).leftLegPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToLeg((ModelPart)part, matrixStackIn);
            modelIn.leftLeg.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.leftLeg, feetItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.FEET, modelIn);
            matrixStackIn.popPose();
        });
    }

    private void renderChestplate(ItemStack chestItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.getModel().copyPropertiesTo((EntityModel)modelIn);
        modelIn.body.xRot = 0.0f;
        modelIn.body.yRot = 0.0f;
        modelIn.body.zRot = 0.0f;
        modelIn.body.x = 0.0f;
        modelIn.body.y = 0.0f;
        modelIn.body.z = 0.0f;
        modelIn.rightArm.x = 0.0f;
        modelIn.rightArm.y = 0.0f;
        modelIn.rightArm.z = 0.0f;
        modelIn.rightArm.xRot = 0.0f;
        modelIn.rightArm.yRot = 0.0f;
        modelIn.rightArm.zRot = 0.0f;
        modelIn.leftArm.x = 0.0f;
        modelIn.leftArm.y = 0.0f;
        modelIn.leftArm.z = 0.0f;
        modelIn.leftArm.xRot = 0.0f;
        modelIn.leftArm.yRot = 0.0f;
        modelIn.leftArm.zRot = 0.0f;
        modelIn.leftArm.y = 0.0f;
        modelIn.rightArm.y = 0.0f;
        modelIn.leftArm.z = 0.0f;
        modelIn.rightArm.z = 0.0f;
        ((IArmor)this.renderer.getModel()).rightHandArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToChestPat((ModelPart)part, matrixStackIn);
            modelIn.rightArm.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.rightArm, chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.popPose();
        });
        ((IArmor)this.renderer.getModel()).leftHandArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToChestPat((ModelPart)part, matrixStackIn);
            modelIn.leftArm.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.leftArm, chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.popPose();
        });
        ((IArmor)this.renderer.getModel()).bodyPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToChest((ModelPart)part, matrixStackIn);
            modelIn.body.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.body, chestItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.CHEST, modelIn);
            matrixStackIn.popPose();
        });
    }

    private void renderHelmet(ItemStack headItem, LivingEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        this.renderer.getModel().copyPropertiesTo((EntityModel)modelIn);
        modelIn.head.xRot = 0.0f;
        modelIn.head.yRot = 0.0f;
        modelIn.head.zRot = 0.0f;
        modelIn.hat.xRot = 0.0f;
        modelIn.hat.yRot = 0.0f;
        modelIn.hat.zRot = 0.0f;
        modelIn.head.x = 0.0f;
        modelIn.head.y = 0.0f;
        modelIn.head.z = 0.0f;
        modelIn.hat.x = 0.0f;
        modelIn.hat.y = 0.0f;
        modelIn.hat.z = 0.0f;
        ((IArmor)this.renderer.getModel()).headPartArmors().forEach(part -> {
            matrixStackIn.pushPose();
            ((IArmor)this.renderer.getModel()).translateToHead((ModelPart)part, matrixStackIn);
            modelIn.head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
            this.renderTrim(modelIn.head, headItem, entity, matrixStackIn, bufferIn, packedLightIn, glintIn, EquipmentSlot.HEAD, modelIn);
            matrixStackIn.popPose();
        });
    }

    protected void setModelSlotVisible(HumanoidModel p_188359_1_, EquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.head.visible = true;
                p_188359_1_.hat.visible = true;
                break;
            }
            case CHEST: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightArm.visible = true;
                p_188359_1_.leftArm.visible = true;
                break;
            }
            case LEGS: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
                break;
            }
            case FEET: {
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
            }
        }
    }

    protected void setModelVisible(HumanoidModel model) {
        model.setAllVisible(false);
    }

    protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        Model basicModel = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
        return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
    }
}

