/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.command.MobEnchantingCommand;
import baguchan.enchantwithmob.message.AncientMessage;
import baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import baguchan.enchantwithmob.message.SoulParticleMessage;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModArmorMaterials;
import baguchan.enchantwithmob.registry.ModCapability;
import baguchan.enchantwithmob.registry.ModDataCompnents;
import baguchan.enchantwithmob.registry.ModEntities;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.registry.ModLootItemFunctions;
import baguchan.enchantwithmob.registry.ModSounds;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.raid.Raid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantwithmob")
public class EnchantWithMob {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "enchantwithmob";
    public static final String NETWORK_PROTOCOL = "2";

    public EnchantWithMob(ModContainer modContainer, IEventBus modEventBus) {
        modEventBus.addListener(this::preSetup);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::setupPackets);
        MobEnchants.MOB_ENCHANT.register(modEventBus);
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModDataCompnents.DATA_COMPONENT_TYPES.register(modEventBus);
        ModItems.ITEM_REGISTRY.register(modEventBus);
        ModArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        ModLootItemFunctions.LOOT_REGISTRY.register(modEventBus);
        ModCapability.ATTACHMENT_TYPES.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EnchantConfig.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EnchantConfig.CLIENT_SPEC);
    }

    private void preSetup(FMLConstructModEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        Raid.RaiderType.create((String)"enchanter", ModEntities.ENCHANTER.get(), (int[])new int[]{0, 0, 1, 0, 1, 1, 2, 1});
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(AncientMessage.TYPE, AncientMessage.STREAM_CODEC, (handler, payload) -> handler.handle((AncientMessage)handler, payload));
        registrar.playBidirectional(MobEnchantedMessage.TYPE, MobEnchantedMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MobEnchantedMessage)handler, payload));
        registrar.playBidirectional(MobEnchantFromOwnerMessage.TYPE, MobEnchantFromOwnerMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MobEnchantFromOwnerMessage)handler, payload));
        registrar.playBidirectional(RemoveAllMobEnchantMessage.TYPE, RemoveAllMobEnchantMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveAllMobEnchantMessage)handler, payload));
        registrar.playBidirectional(RemoveMobEnchantOwnerMessage.TYPE, RemoveMobEnchantOwnerMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveMobEnchantOwnerMessage)handler, payload));
        registrar.playBidirectional(SoulParticleMessage.TYPE, SoulParticleMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SoulParticleMessage)handler, payload));
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        MobEnchantingCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }
}

