/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.capability;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.message.AncientMessage;
import baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MobEnchantCapability {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("6699a403-e2cc-31e6-195e-4757200e0935");
    private static final AttributeModifier HEALTH_MODIFIER = new AttributeModifier(HEALTH_MODIFIER_UUID, "Health boost", 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private List<MobEnchantHandler> mobEnchants = Lists.newArrayList();
    @Nullable
    private LivingEntity enchantOwner;
    private boolean fromOwner;
    private EnchantType enchantType = EnchantType.NORMAL;

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        if (!entity.level().isClientSide) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        entity.refreshDimensions();
    }

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, boolean ancient) {
        this.addMobEnchant(entity, mobEnchant, enchantLevel);
        this.setEnchantType(entity, ancient ? EnchantType.ANCIENT : EnchantType.NORMAL);
    }

    public void setEnchantType(LivingEntity entity, EnchantType enchantType) {
        this.enchantType = enchantType;
        if (!entity.level().isClientSide) {
            AncientMessage message = new AncientMessage((Entity)entity, enchantType == EnchantType.ANCIENT);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void addMobEnchantFromOwner(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, LivingEntity owner) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        if (!entity.level().isClientSide) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.addOwner(entity, owner);
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        entity.refreshDimensions();
    }

    public void addOwner(LivingEntity entity, LivingEntity owner) {
        this.fromOwner = true;
        this.enchantOwner = owner;
        if (!entity.level().isClientSide) {
            MobEnchantFromOwnerMessage message = new MobEnchantFromOwnerMessage((Entity)entity, (Entity)owner);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void removeOwner(LivingEntity livingEntity) {
        this.fromOwner = false;
        this.enchantOwner = null;
        if (!livingEntity.level().isClientSide) {
            RemoveMobEnchantOwnerMessage message = new RemoveMobEnchantOwnerMessage((Entity)livingEntity);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void removeAllMobEnchant(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.level().isClientSide) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        entity.refreshDimensions();
    }

    public void removeMobEnchantFromOwner(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.level().isClientSide) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        this.removeOwner(entity);
        entity.refreshDimensions();
    }

    public void onNewEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        AttributeInstance modifiableattributeinstance;
        enchant.applyAttributesModifiersToEntity(entity, entity.getAttributes(), enchantLevel);
        if (((Boolean)EnchantConfig.COMMON.dungeonsLikeHealth.get()).booleanValue() && (modifiableattributeinstance = entity.getAttributes().getInstance(Attributes.MAX_HEALTH)) != null && !modifiableattributeinstance.hasModifier(HEALTH_MODIFIER)) {
            modifiableattributeinstance.removeModifier(HEALTH_MODIFIER_UUID);
            modifiableattributeinstance.addPermanentModifier(HEALTH_MODIFIER);
            entity.setHealth(entity.getHealth() * 1.25f);
        }
    }

    public void onChangedEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        enchant.applyAttributesModifiersToEntity(entity, entity.getAttributes(), enchantLevel);
    }

    protected void onRemoveEnchantEffect(LivingEntity entity, MobEnchant enchant) {
        enchant.removeAttributesModifiersFromEntity(entity, entity.getAttributes());
        AttributeInstance modifiableattributeinstance = entity.getAttributes().getInstance(Attributes.MAX_HEALTH);
        if (modifiableattributeinstance != null && modifiableattributeinstance.hasModifier(HEALTH_MODIFIER)) {
            entity.setHealth(entity.getHealth() / 1.25f);
            modifiableattributeinstance.removeModifier(HEALTH_MODIFIER_UUID);
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    @Nullable
    public LivingEntity getEnchantOwner() {
        return this.enchantOwner;
    }

    public boolean hasOwner() {
        return this.enchantOwner != null && this.enchantOwner.isAlive();
    }

    public boolean isFromOwner() {
        return this.fromOwner;
    }

    public EnchantType getEnchantType() {
        return this.enchantType;
    }

    public boolean isAncient() {
        return this.enchantType == EnchantType.ANCIENT;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.put("StoredMobEnchants", (Tag)listnbt);
        nbt.putBoolean("FromOwner", this.fromOwner);
        nbt.putString("EnchantType", this.enchantType.name());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        this.mobEnchants.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.getCompound(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
            if (mobEnchant == null) continue;
            this.mobEnchants.add(new MobEnchantHandler(mobEnchant, MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
        this.fromOwner = nbt.getBoolean("FromOwner");
        this.enchantType = EnchantType.get(nbt.getString("EnchantType"));
    }

    public static enum EnchantType {
        NORMAL,
        ANCIENT;


        public static EnchantType get(String nameIn) {
            for (EnchantType enchantType : EnchantType.values()) {
                if (!enchantType.name().equals(nameIn)) continue;
                return enchantType;
            }
            return NORMAL;
        }
    }
}

