/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.enchantwithmob.client.animation.EnchanterAnimation;
import baguchan.enchantwithmob.entity.Enchanter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterModel<T extends Enchanter>
extends HierarchicalModel<T>
implements IArmor {
    private final ModelPart realRoot;
    private final ModelPart everything;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart Cape;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart righteyebrows;
    private final ModelPart lefteyebrows;
    private final ModelPart left_arm;
    private final ModelPart leftHand;
    private final ModelPart right_arm;
    private final ModelPart rightHand;
    private final ModelPart arms;
    private final ModelPart book;
    private final ModelPart leftBookCover;
    private final ModelPart rightBookCover;
    private final ModelPart pages;
    private final ModelPart leftPage;
    private final ModelPart leftPage2;

    public EnchanterModel(ModelPart root) {
        this.realRoot = root;
        this.everything = root.getChild("everything");
        this.left_leg = this.everything.getChild("left_leg");
        this.right_leg = this.everything.getChild("right_leg");
        this.body = this.everything.getChild("body");
        this.Cape = this.body.getChild("Cape");
        this.head = this.body.getChild("head");
        this.hat = this.head.getChild("hat");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.righteyebrows = this.head.getChild("righteyebrows");
        this.lefteyebrows = this.head.getChild("lefteyebrows");
        this.left_arm = this.body.getChild("left_arm");
        this.leftHand = this.left_arm.getChild("leftHand");
        this.right_arm = this.body.getChild("right_arm");
        this.rightHand = this.right_arm.getChild("rightHand");
        this.arms = this.body.getChild("arms");
        this.book = this.everything.getChild("book");
        this.leftBookCover = this.book.getChild("leftBookCover");
        this.rightBookCover = this.book.getChild("rightBookCover");
        this.pages = this.book.getChild("pages");
        this.leftPage = this.pages.getChild("leftPage");
        this.leftPage2 = this.pages.getChild("leftPage2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition Cape = body.addOrReplaceChild("Cape", CubeListBuilder.create().texOffs(0, 64).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 23.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(1, 91).addBox(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(6, 5).addBox(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(6, 5).addBox(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.addOrReplaceChild("righteyebrows", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.addOrReplaceChild("righteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.addOrReplaceChild("lefteyebrows", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.addOrReplaceChild("lefteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftHand = left_arm.addOrReplaceChild("leftHand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightHand = right_arm.addOrReplaceChild("rightHand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)11.0f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-0.95f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition book = everything.addOrReplaceChild("book", CubeListBuilder.create().texOffs(43, 72).addBox(-2.0f, -3.0f, -1.0f, 3.0f, 9.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.5f, (float)-18.5f, (float)-9.0f));
        PartDefinition leftBookCover = book.addOrReplaceChild("leftBookCover", CubeListBuilder.create().texOffs(26, 72).mirror().addBox(-8.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(44, 62).addBox(-6.9f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition rightBookCover = book.addOrReplaceChild("rightBookCover", CubeListBuilder.create().texOffs(26, 62).addBox(0.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 62).addBox(-0.1f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition pages = book.addOrReplaceChild("pages", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)-0.1f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftPage = pages.addOrReplaceChild("leftPage", CubeListBuilder.create().texOffs(26, 82).addBox(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition leftPage2 = pages.addOrReplaceChild("leftPage2", CubeListBuilder.create().texOffs(26, 82).addBox(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.Cape.xRot = 0.1f + limbSwingAmount * 0.6f;
        if (this.riding) {
            this.applyStatic(EnchanterAnimation.SIT);
        }
        if (((Enchanter)((Object)entity)).castingAnimationState.isStarted()) {
            this.animate(((Enchanter)((Object)entity)).castingAnimationState, EnchanterAnimation.ENCHANCE, ageInTicks);
        } else if (((Enchanter)((Object)entity)).attackAnimationState.isStarted()) {
            this.animate(((Enchanter)((Object)entity)).attackAnimationState, EnchanterAnimation.ATTACK, ageInTicks);
        } else if (!((Enchanter)((Object)entity)).castingAnimationState.isStarted() && !((Enchanter)((Object)entity)).attackAnimationState.isStarted()) {
            if (!((Enchanter)((Object)entity)).idleAnimationState.isStarted()) {
                this.animateWalk(EnchanterAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 4.5f);
                this.applyStatic(EnchanterAnimation.WALK_STOP);
            } else {
                this.animate(((Enchanter)((Object)entity)).idleAnimationState, EnchanterAnimation.IDLE, ageInTicks);
            }
        }
    }

    public ModelPart root() {
        return this.realRoot;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.2f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.75f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        if (this.rightHand == modelPart) {
            this.right_arm.translateAndRotate(poseStack);
        }
        if (this.leftHand == modelPart) {
            this.left_arm.translateAndRotate(poseStack);
        }
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.75f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightHand);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftHand);
    }
}

