/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.item;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.registry.ModDataCompnents;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnchantersBookItem
extends Item {
    private final TargetingConditions enchantTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final TargetingConditions alreadyEnchantTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting().selector(entity -> {
        IEnchantCap enchantCap;
        return entity instanceof IEnchantCap && (enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
    });

    public EnchantersBookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!MobEnchantUtils.hasMobEnchant(stack)) return super.use(level, playerIn, handIn);
        List list = level.getNearbyEntities(LivingEntity.class, this.enchantTargeting, (LivingEntity)playerIn, playerIn.getBoundingBox().inflate(16.0));
        List hasEnchantedMoblist = level.getNearbyEntities(LivingEntity.class, this.alreadyEnchantTargeting, (LivingEntity)playerIn, playerIn.getBoundingBox().inflate(16.0));
        if (hasEnchantedMoblist.isEmpty() || hasEnchantedMoblist.size() < 5) {
            if (!list.isEmpty()) {
                int size = list.size();
                boolean[] flag = new boolean[]{false};
                for (int i = 0; i < size; ++i) {
                    IEnchantCap cap;
                    LivingEntity enchantedMob = (LivingEntity)list.get(i);
                    if (i >= 5) break;
                    if (enchantedMob.canAttack((LivingEntity)playerIn) || playerIn == enchantedMob || !(enchantedMob instanceof IEnchantCap) || (cap = (IEnchantCap)enchantedMob).getEnchantCap().hasEnchant()) continue;
                    if (flag[0]) {
                        MobEnchantUtils.addUnstableItemMobEnchantToEntity(stack, enchantedMob, (LivingEntity)playerIn, cap);
                        continue;
                    }
                    flag[0] = MobEnchantUtils.addUnstableItemMobEnchantToEntity(stack, enchantedMob, (LivingEntity)playerIn, cap);
                }
                if (!flag[0]) return super.use(level, playerIn, handIn);
                level.playSound(playerIn, playerIn.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                playerIn.getCooldowns().addCooldown(stack.getItem(), 40);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
            playerIn.getCooldowns().addCooldown(stack.getItem(), 20);
            return InteractionResultHolder.fail((Object)stack);
        }
        playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
        playerIn.getCooldowns().addCooldown(stack.getItem(), 20);
        return InteractionResultHolder.fail((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.appendHoverText(stack, level, tooltip, p_41424_);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        Consumer<Component> consumer = tooltip::add;
        stack.addToTooltip((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), level, consumer, p_41424_);
        tooltip.add((Component)Component.translatable((String)"mobenchant.enchantwithmob.enchanter_book.tooltip").withStyle(textformatting2));
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

