/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.item;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.registry.ModDataCompnents;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MobEnchantBookItem
extends Item {
    public MobEnchantBookItem(Item.Properties group) {
        super(group);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (((Boolean)EnchantConfig.COMMON.enchantYourSelf.get()).booleanValue() && MobEnchantUtils.hasMobEnchant(stack) && playerIn instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerIn;
            boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, (LivingEntity)playerIn, (LivingEntity)playerIn, cap);
            if (flag) {
                level.playSound(playerIn, playerIn.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                playerIn.getCooldowns().addCooldown(stack.getItem(), 40);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.enchant_yourself"), true);
            playerIn.getCooldowns().addCooldown(stack.getItem(), 20);
            return InteractionResultHolder.fail((Object)stack);
        }
        return super.use(level, playerIn, handIn);
    }

    public static List<ItemStack> generateMobEnchantmentBookTypesOnlyMaxLevel() {
        ArrayList items = Lists.newArrayList();
        for (MobEnchant mobEnchant : MobEnchants.getRegistry()) {
            if (mobEnchant.isDisabled()) continue;
            ItemStack stack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.get());
            MobEnchantUtils.enchant(mobEnchant, stack, mobEnchant.getMaxLevel());
            items.add(stack);
        }
        for (MobEnchant mobEnchant : MobEnchants.getRegistry()) {
            if (mobEnchant.isDisabled()) continue;
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.get());
            MobEnchantUtils.enchant(mobEnchant, stack2, mobEnchant.getMaxLevel());
            items.add(stack2);
        }
        return items;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.appendHoverText(stack, level, tooltip, p_41424_);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        Consumer<Component> consumer = tooltip::add;
        stack.addToTooltip((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), level, consumer, p_41424_);
        tooltip.add((Component)Component.translatable((String)"mobenchant.enchantwithmob.mob_enchant_book.tooltip").withStyle(textformatting2));
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

