/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mobenchant;

import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber(modid="enchantwithmob")
public class DeflectMobEnchant
extends MobEnchant {
    public DeflectMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 30;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 30;
    }

    @SubscribeEvent
    public static void onHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)event.getRayTraceResult();
            MobEnchantUtils.executeIfPresent(entityHitResult.getEntity(), (MobEnchant)MobEnchants.DEFLECT.get(), () -> {
                event.setCanceled(true);
                Vec3 vec3 = projectile.getDeltaMovement();
                projectile.setDeltaMovement(-vec3.x * 0.75, -vec3.y * 0.75, -vec3.z * 0.75);
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    arrow.setPierceLevel((byte)0);
                }
            });
        }
    }

    @Override
    protected boolean canApplyTogether(MobEnchant ench) {
        return super.canApplyTogether(ench) && ench != MobEnchants.THORN.get();
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }
}

