/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.epicsamurai.entity.custom;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.veroxuniverse.epicsamurai.enchantment.ModEnchantments;
import net.veroxuniverse.epicsamurai.entity.custom.goals.KitsuneAttackGoal;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KitsuneEntity
extends Monster
implements IAnimatable {
    private boolean invulnerable;
    private final AnimationFactory FACTORY = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("animation.kitsune.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.kitsune.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private static final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("animation.kitsune.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);

    public KitsuneEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, (double)0.3f).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new KitsuneAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false));
    }

    public int m_21304_() {
        return 18;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, event -> {
            if (event.isMoving() && !this.f_20911_) {
                event.getController().setAnimation(WALK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && !this.f_20911_) {
                event.getController().setAnimation(IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, event -> {
            if (this.f_20911_) {
                event.getController().setAnimation(ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            event.getController().markNeedsReload();
            return PlayState.STOP;
        }));
    }

    public boolean hasEnchantment(Enchantment pEnchantment, LivingEntity pEntity) {
        if (pEntity != null) {
            return EnchantmentHelper.m_44836_((Enchantment)pEnchantment, (LivingEntity)pEntity) > 0;
        }
        return false;
    }

    public boolean m_6673_(DamageSource pSource) {
        LivingEntity attacker = (LivingEntity)pSource.m_7639_();
        Enchantment enchantment = (Enchantment)ModEnchantments.DEMON_SLAYER.get();
        boolean hasSpiritSlayer = this.hasEnchantment(enchantment, attacker);
        if (!hasSpiritSlayer && !pSource.m_19390_() && attacker != null) {
            return true;
        }
        return pSource.m_19360_() || super.m_6673_(pSource);
    }

    public AnimationFactory getFactory() {
        return this.FACTORY;
    }

    static boolean hurtAndThrowTarget(LivingEntity pKitsune, LivingEntity pTarget) {
        float f1 = (float)pKitsune.m_21133_(Attributes.f_22281_);
        float f = (int)f1 > 0 ? f1 / 2.0f + (float)pKitsune.f_19853_.f_46441_.m_188503_((int)f1) : f1;
        boolean flag = pTarget.m_6469_(DamageSource.m_19370_((LivingEntity)pKitsune), f);
        if (flag) {
            pKitsune.m_19970_(pKitsune, (Entity)pTarget);
            HoglinBase.m_34645_((LivingEntity)pKitsune, (LivingEntity)pTarget);
        }
        return flag;
    }

    public boolean m_7327_(Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.m_5496_(SoundEvents.f_11945_, 1.0f, 0.4f);
        return KitsuneEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)pEntity);
    }

    public int m_5792_() {
        return 6;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11948_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public float m_6100_() {
        return 0.5f;
    }
}

