/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.epicsamurai.registry;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.veroxuniverse.epicsamurai.compat.CreateCompat;
import net.veroxuniverse.epicsamurai.registry.ItemsRegistry;
import org.jetbrains.annotations.NotNull;

public enum ArmorMaterialsRegistry implements ArmorMaterial
{
    SAMURAI_RUBY("samurai_ruby", 33, new int[]{3, 6, 8, 2}, 25, SoundEvents.f_11673_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.RUBY.get()})),
    SAMURAI_ONYX("samurai_onyx", 33, new int[]{3, 6, 8, 2}, 25, SoundEvents.f_11673_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.ONYX.get()})),
    SAMURAI_AQUA("samurai_aqua", 33, new int[]{3, 6, 8, 2}, 25, SoundEvents.f_11673_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.AQUAMARINE.get()})),
    SAMURAI_JADE("samurai_jade", 33, new int[]{3, 6, 8, 2}, 25, SoundEvents.f_11673_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.JADE.get()})),
    SAMURAI_SILVER("samurai_silver", 20, new int[]{2, 5, 6, 2}, 12, SoundEvents.f_11677_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.SILVER_INGOT.get()})),
    SAMURAI_DIAMOND("samurai_diamond", 33, new int[]{3, 6, 8, 2}, 12, SoundEvents.f_11673_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    SAMURAI_BRASS("samurai_brass", 33, new int[]{3, 6, 8, 2}, 12, SoundEvents.f_11677_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CreateCompat.BRASS_REPAIR_KIT.get()})),
    SAMURAI_NETHERITE("samurai_netherite", 45, new int[]{3, 6, 8, 3}, 25, SoundEvents.f_11679_, 2.5f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})),
    SAMURAI_SCULK("samurai_sculk", 55, new int[]{3, 6, 8, 3}, 25, SoundEvents.f_11679_, 3.0f, 0.5f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220224_})),
    SAMURAI_AMETHYST("samurai_amethyst", 35, new int[]{3, 6, 8, 3}, 25, SoundEvents.f_144053_, 2.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.AMETHYST_INGOT.get()})),
    SAMURAI_QUARTZ("samurai_quartz", 35, new int[]{3, 6, 8, 3}, 25, SoundEvents.f_11673_, 2.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.QUARTZ_INGOT.get()})),
    SAMURAI_GOLD("samurai_gold", 15, new int[]{2, 4, 5, 2}, 25, SoundEvents.f_11676_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})),
    SAMURAI_IRON("samurai_iron", 20, new int[]{2, 5, 6, 2}, 12, SoundEvents.f_11677_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})),
    STEEL("steel", 29, new int[]{3, 5, 7, 2}, 12, SoundEvents.f_11677_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsRegistry.STEEL_INGOT.get()})),
    STRAW("straw", 15, new int[]{1, 1, 1, 1}, 7, SoundEvents.f_11678_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ArmorMaterialsRegistry(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_7366_(EquipmentSlot pSlot) {
        return HEALTH_PER_SLOT[pSlot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot pSlot) {
        return this.slotProtections[pSlot.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.sound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return "epicsamurai:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

