/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.femalevillagers.config.Config;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.npc.AbstractVillager;

public class FemaleVillagerModel<T extends AbstractVillager>
extends VillagerModel<T>
implements ArmedModel {
    private static final ResourceLocation MODEL_ID = new ResourceLocation("femalevillagers", "female_villager");
    public static final ModelLayerLocation MAIN_LAYER_LOCATION = new ModelLayerLocation(MODEL_ID, "main");
    public static final ModelLayerLocation HAIR_LAYER_LOCATION = new ModelLayerLocation(MODEL_ID, "hair");
    protected final ModelPart rightArm;
    protected final ModelPart leftArm;
    protected final ModelPart f_104036_;
    protected final ModelPart f_104037_;
    protected final ModelPart f_104038_;
    protected final ModelPart f_171048_;
    protected final ModelPart f_171049_;
    protected final ModelPart f_104044_;
    protected final ModelPart body;
    protected final ModelPart arms;

    public FemaleVillagerModel(ModelPart root) {
        super(root);
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.f_104036_ = root.m_171324_("head");
        this.f_104037_ = this.f_104036_.m_171324_("hat");
        this.f_104038_ = this.f_104037_.m_171324_("hat_rim");
        this.f_104044_ = this.f_104036_.m_171324_("nose");
        this.f_171048_ = root.m_171324_("right_leg");
        this.f_171049_ = root.m_171324_("left_leg");
        this.body = root.m_171324_("body");
        this.arms = root.m_171324_("arms");
        if (((Boolean)Config.COMMON.useDefaultVillagerArms.get()).booleanValue()) {
            this.leftArm.f_104207_ = false;
            this.rightArm.f_104207_ = false;
        } else {
            this.arms.f_104207_ = false;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = FemaleVillagerModel.createBodyModel();
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static MeshDefinition createBodyModel() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        root.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(40, 38).m_171488_(-4.0f, 4.0f, -1.5f, 8.0f, 3.0f, 4.0f, new CubeDeformation(-0.01f)).m_171514_(44, 22).m_171481_(-6.5f, -1.0f, -1.5f, 3.0f, 8.0f, 4.0f).m_171514_(44, 22).m_171480_().m_171481_(3.5f, -1.0f, -1.5f, 3.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.2f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.8f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)2.4f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.3f)), PartPose.f_171404_);
        hat.m_171599_("hat_rim", CubeListBuilder.m_171558_().m_171514_(30, 47).m_171488_(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.3f)), PartPose.m_171430_((float)-1.5708f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -5.25f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(-0.45f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        body.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.05f)), PartPose.f_171404_);
        PartDefinition breast = body.m_171599_("breast", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        breast.m_171599_("breast_overlay", CubeListBuilder.m_171558_().m_171514_(4, 42).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)).m_171514_(18, 29).m_171480_().m_171488_(-4.0f, 3.25f, 0.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(-0.51f)).m_171514_(19, 24).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.m_171430_((float)-0.48f, (float)0.0f, (float)0.0f));
        breast.m_171599_("breast_bottom_overlay", CubeListBuilder.m_171558_().m_171514_(2, 47).m_171480_().m_171488_(-4.0f, -0.5f, -1.5f, 8.0f, -1.0f, 4.0f, new CubeDeformation(-0.19f)), PartPose.m_171423_((float)0.0f, (float)5.2916f, (float)-0.9997f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(45, 22).m_171480_().m_171481_(-1.5f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f), PartPose.m_171423_((float)5.0f, (float)4.0f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("cube_1", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-2.5f, -2.0f, -4.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)1.5708f));
        left_arm.m_171599_("cube_2", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)-1.5708f));
        left_arm.m_171599_("cube_3", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)-1.5708f, (float)3.1416f, (float)1.5708f));
        left_arm.m_171599_("cube_4", CubeListBuilder.m_171558_().m_171514_(40, 43).m_171480_().m_171488_(-1.5f, -1.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)-1.5708f));
        left_arm.m_171599_("cube_5", CubeListBuilder.m_171558_().m_171514_(36, 38).m_171488_(-2.5f, -1.0f, 0.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)3.1416f, (float)3.1416f, (float)1.5708f));
        PartDefinition right_arm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(45, 22).m_171481_(-1.5f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-5.0f, (float)4.0f, (float)0.0f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("cube_6", CubeListBuilder.m_171558_().m_171514_(36, 38).m_171480_().m_171488_(-2.5f, -2.0f, -4.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(40, 43).m_171488_(-2.5f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)1.5708f));
        right_arm.m_171599_("cube_7", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171488_(-1.5f, -1.0f, -4.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)-1.5708f));
        right_arm.m_171599_("cube_8", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171488_(-1.5f, -4.0f, -2.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)1.5708f, (float)3.1416f, (float)-1.5708f));
        right_arm.m_171599_("cube_9", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-0.5f, (float)7.5f, (float)-2.0f, (float)1.5708f, (float)3.1416f, (float)1.5708f));
        return meshDefinition;
    }

    public static LayerDefinition createHairLayer() {
        MeshDefinition meshDefinition = FemaleVillagerModel.createBodyModel();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)2.4f, (float)0.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void copyPropertiesTo(FemaleVillagerModel<T> model) {
        super.m_102624_(model);
        model.rightArm.m_104315_(this.rightArm);
        model.leftArm.m_104315_(this.leftArm);
        model.f_104036_.m_104315_(this.f_104036_);
        model.f_104037_.m_104315_(this.f_104037_);
        model.f_104038_.m_104315_(this.f_104038_);
        model.f_171048_.m_104315_(this.f_171048_);
        model.f_171049_.m_104315_(this.f_171049_);
        model.f_104044_.m_104315_(this.f_104044_);
        model.body.m_104315_(this.body);
        model.arms.m_104315_(this.arms);
    }

    public void setupAnim(T villager, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(villager, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean isFalling = villager.m_21256_() > 4;
        float f = 1.0f;
        if (isFalling) {
            f = (float)villager.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        ModelPart modelpart = this.getArm(arm);
        float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
        modelpart.f_104200_ += f;
        modelpart.m_104299_(poseStack);
        modelpart.f_104200_ -= f;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }
}

