/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.guardvillagers;

import daripher.femalevillagers.compat.guardvillagers.client.model.FemaleGuardArmorModel;
import daripher.femalevillagers.compat.guardvillagers.client.model.FemaleGuardModel;
import daripher.femalevillagers.compat.guardvillagers.client.render.FemaleGuardRenderer;
import daripher.femalevillagers.compat.guardvillagers.entity.FemaleGuard;
import daripher.femalevillagers.entity.FemaleVillager;
import daripher.femalevillagers.init.EntityInit;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

public enum GuardVillagersCompatibility {
    INSTANCE;

    private static final ResourceLocation FEMALE_GUARD_ENTITY_ID;

    public void addCompatibility() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::createAttributes);
        modEventBus.addListener(this::registerEntityType);
        modEventBus.addListener(this::registerRenderer);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::attemptConvertingVillager);
    }

    public Entity createFemaleGuard(Entity guard) {
        Guard replacedEntity = (Guard)guard;
        FemaleGuard replacementEntity = new FemaleGuard(guard.f_19853_);
        replacementEntity.setGuardVariant(replacedEntity.getGuardVariant());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            replacementEntity.m_8061_(slot, replacedEntity.m_6844_(slot));
        }
        return replacementEntity;
    }

    public void registerFemaleIllusionerRaiderType() {
        if (GuardConfig.IllusionerRaids) {
            Raid.RaiderType.create((String)"FEMALE_ILLUSIONER", (EntityType)((EntityType)EntityInit.FEMALE_ILLUSIONER.get()), (int[])new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        }
    }

    public EntityType<FemaleGuard> getFemaleGuardEntityType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(FEMALE_GUARD_ENTITY_ID);
    }

    private void createAttributes(EntityAttributeCreationEvent event) {
        event.put(this.getFemaleGuardEntityType(), Guard.createAttributes().m_22265_());
    }

    private void registerEntityType(RegisterEvent event) {
        event.register(Registries.f_256939_, FEMALE_GUARD_ENTITY_ID, FemaleGuard::createEntityType);
    }

    private void attemptConvertingVillager(PlayerInteractEvent.EntityInteract event) {
        boolean isHoldingWeapon;
        Player player = event.getEntity();
        ItemStack itemInHand = event.getEntity().m_21205_();
        Entity target = event.getTarget();
        boolean bl = isHoldingWeapon = itemInHand.m_41720_() instanceof SwordItem || itemInHand.m_41720_() instanceof CrossbowItem;
        if (!isHoldingWeapon || !player.m_6047_()) {
            return;
        }
        if (target instanceof Villager) {
            boolean canPlayerConvertVillagers;
            boolean hasProfession;
            Villager villager = (Villager)target;
            if (villager.m_6162_()) {
                return;
            }
            VillagerProfession profession = villager.m_7141_().m_35571_();
            boolean bl2 = hasProfession = profession != VillagerProfession.f_35585_ && profession != VillagerProfession.f_35596_;
            if (hasProfession) {
                return;
            }
            boolean bl3 = canPlayerConvertVillagers = !GuardConfig.ConvertVillagerIfHaveHOTV || player.m_21023_(MobEffects.f_19595_) && GuardConfig.ConvertVillagerIfHaveHOTV;
            if (!canPlayerConvertVillagers) {
                return;
            }
            this.convertVillager((LivingEntity)villager, player);
            event.setCanceled(true);
            if (!player.m_7500_()) {
                itemInHand.m_41774_(1);
            }
        }
    }

    private void registerRenderer(FMLClientSetupEvent event) {
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)FemaleGuardModel.LAYER_LOCATION, FemaleGuardModel::createBodyLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)FemaleGuardArmorModel.INNER_LAYER_LOCATION, FemaleGuardArmorModel::createInnerArmorLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)FemaleGuardArmorModel.OUTER_LAYER_LOCATION, FemaleGuardArmorModel::createOuterArmorLayer);
        EntityRenderers.m_174036_(this.getFemaleGuardEntityType(), FemaleGuardRenderer::new);
    }

    private void convertVillager(LivingEntity entity, Player player) {
        player.m_6674_(InteractionHand.MAIN_HAND);
        ItemStack itemInHand = player.m_6844_(EquipmentSlot.MAINHAND);
        Guard guard = (Guard)((EntityType)GuardEntityType.GUARD.get()).m_20615_(entity.f_19853_);
        if (entity instanceof FemaleVillager) {
            guard = new FemaleGuard(entity.f_19853_);
        } else {
            guard.m_20049_("do_not_replace");
        }
        Villager villager = (Villager)entity;
        if (entity.f_19853_.f_46443_) {
            SimpleParticleType particle = ParticleTypes.f_123748_;
            for (int i = 0; i < 10; ++i) {
                double particleMotionX = villager.m_217043_().m_188583_() * 0.02;
                double particleMotionY = villager.m_217043_().m_188583_() * 0.02;
                double particleMotionZ = villager.m_217043_().m_188583_() * 0.02;
                double particleX = villager.m_20185_() + (double)(villager.m_217043_().m_188501_() * villager.m_20205_() * 2.0f) - (double)villager.m_20205_();
                double particleY = villager.m_20186_() + 0.5 + (double)(villager.m_217043_().m_188501_() * villager.m_20206_());
                double particleZ = villager.m_20189_() + (double)(villager.m_217043_().m_188501_() * villager.m_20205_() * 2.0f) - (double)villager.m_20205_();
                villager.f_19853_.m_7106_((ParticleOptions)particle, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
        guard.m_20359_((Entity)villager);
        guard.m_5496_(SoundEvents.f_12509_, 1.0f, 1.0f);
        guard.m_8061_(EquipmentSlot.MAINHAND, itemInHand.m_41777_());
        int guardVariant = Guard.getRandomTypeForBiome((LevelAccessor)guard.f_19853_, (BlockPos)guard.m_20183_());
        guard.setGuardVariant(guardVariant);
        guard.m_21530_();
        guard.m_6593_(villager.m_7770_());
        guard.m_20340_(villager.m_20151_());
        guard.m_21409_(EquipmentSlot.HEAD, 100.0f);
        guard.m_21409_(EquipmentSlot.CHEST, 100.0f);
        guard.m_21409_(EquipmentSlot.FEET, 100.0f);
        guard.m_21409_(EquipmentSlot.LEGS, 100.0f);
        guard.m_21409_(EquipmentSlot.MAINHAND, 100.0f);
        guard.m_21409_(EquipmentSlot.OFFHAND, 100.0f);
        guard.getGossips().m_26191_(player.m_20148_(), GossipType.MINOR_POSITIVE, GuardConfig.reputationRequirement);
        villager.f_19853_.m_7967_((Entity)guard);
        villager.m_35428_(MemoryModuleType.f_26359_);
        villager.m_35428_(MemoryModuleType.f_26360_);
        villager.m_35428_(MemoryModuleType.f_26362_);
        villager.m_146870_();
    }

    static {
        FEMALE_GUARD_ENTITY_ID = new ResourceLocation("femalevillagers", "female_guard");
    }
}

