/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.guardvillagers.client.model;

import daripher.femalevillagers.compat.guardvillagers.entity.FemaleGuard;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;

public class FemaleGuardModel
extends HumanoidModel<FemaleGuard> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("femalevillagers", "female_guard"), "main");
    public ModelPart quiver;
    public ModelPart leftShoulderPad;
    public ModelPart rightShoulderPad;

    public FemaleGuardModel(ModelPart root) {
        super(root);
        this.quiver = this.f_102810_.m_171324_("quiver");
        this.leftShoulderPad = this.f_102811_.m_171324_("shoulder_pad_left");
        this.rightShoulderPad = this.f_102812_.m_171324_("shoulder_pad_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition model = new MeshDefinition();
        PartDefinition root = model.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(52, 50).m_171488_(-4.0f, -23.25f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(-0.15f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition breast = body.m_171599_("breast", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-22.0f, (float)-2.25f, (float)0.1309f, (float)0.0f, (float)0.0f));
        breast.m_171599_("breast_bottom_r1", CubeListBuilder.m_171558_().m_171514_(52, 57).m_171488_(-4.0f, 4.25f, -0.25f, 8.0f, 1.0f, 4.0f, new CubeDeformation(-0.51f)).m_171514_(53, 53).m_171488_(-4.0f, 0.25f, -0.25f, 8.0f, 5.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition quiver = body.m_171599_("quiver", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        quiver.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-5.5f, -21.75f, 1.75f, 5.0f, 10.0f, 5.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-1.8f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 28).m_171480_().m_171488_(-2.2f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(-0.2f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(49, 99).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-1.0f, -1.0f, -5.25f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        root.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.275f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(34, 48).m_171480_().m_171488_(0.25f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)4.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("shoulder_pad_right", CubeListBuilder.m_171558_().m_171514_(72, 33).m_171488_(-1.5f, -4.25f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition right_arm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(33, 75).m_171488_(-2.25f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)4.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("shoulder_pad_left", CubeListBuilder.m_171558_().m_171514_(40, 20).m_171488_(-3.5328f, -4.25f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        return LayerDefinition.m_171565_((MeshDefinition)model, (int)128, (int)128);
    }

    public void setupAnim(FemaleGuard entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        boolean isHoldingShootable;
        super.m_6973_((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
        ItemStack itemInHand = entityIn.m_21120_(InteractionHand.MAIN_HAND);
        this.quiver.f_104207_ = isHoldingShootable = itemInHand.m_41720_() instanceof ProjectileWeaponItem;
        boolean hasChestplate = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem;
        this.leftShoulderPad.f_104207_ = !hasChestplate;
        this.rightShoulderPad.f_104207_ = !hasChestplate;
        this.f_102812_.f_104200_ = 3.5f;
        this.f_102812_.f_104201_ = 4.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102811_.f_104200_ = -4.5f;
        this.f_102811_.f_104201_ = 4.0f;
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102810_.f_104200_ = 0.0f;
        this.f_102810_.f_104201_ = 24.0f;
        this.f_102810_.f_104202_ = 0.0f;
        this.f_102808_.f_104200_ = 0.0f;
        this.f_102808_.f_104201_ = 2.0f;
        this.f_102808_.f_104202_ = 0.0f;
        this.f_102809_.f_104200_ = 0.0f;
        this.f_102809_.f_104201_ = 2.0f;
        this.f_102809_.f_104202_ = 0.0f;
        if (entityIn.getKickTicks() > 0) {
            float kickAnimationProgress = 1.0f - (float)Mth.m_14040_((int)(10 - 2 * entityIn.getKickTicks())) / 10.0f;
            this.f_102813_.f_104203_ = Mth.m_14179_((float)kickAnimationProgress, (float)this.f_102813_.f_104203_, (float)-1.4f);
        }
        if (this.f_102608_ == 0.0f && entityIn.m_5912_() && !isHoldingShootable && entityIn.m_20184_().m_165925_() > 0.005 && !entityIn.m_21205_().m_41619_() && !entityIn.m_21254_()) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)entityIn, (float)this.f_102608_, (float)ageInTicks);
        }
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    public void eatingAnimationRightHand(InteractionHand hand, FemaleGuard entity, float ageInTicks) {
        boolean isDrinkingOrEating;
        ItemStack itemInHand = entity.m_21120_(hand);
        boolean bl = isDrinkingOrEating = itemInHand.m_41780_() == UseAnim.EAT || itemInHand.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && isDrinkingOrEating) {
            this.f_102811_.f_104204_ = -0.5f;
            this.f_102811_.f_104203_ = -1.3f;
            this.f_102811_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }

    public void eatingAnimationLeftHand(InteractionHand hand, FemaleGuard entity, float ageInTicks) {
        boolean isDrinkingOrEating;
        ItemStack itemInHand = entity.m_21120_(hand);
        boolean bl = isDrinkingOrEating = itemInHand.m_41780_() == UseAnim.EAT || itemInHand.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && isDrinkingOrEating) {
            this.f_102812_.f_104204_ = 0.5f;
            this.f_102812_.f_104203_ = -1.3f;
            this.f_102812_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }
}

