/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.guardvillagers.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.femalevillagers.compat.guardvillagers.client.model.FemaleGuardArmorModel;
import daripher.femalevillagers.compat.guardvillagers.client.model.FemaleGuardModel;
import daripher.femalevillagers.compat.guardvillagers.entity.FemaleGuard;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class FemaleGuardRenderer
extends HumanoidMobRenderer<FemaleGuard, HumanoidModel<FemaleGuard>> {
    public FemaleGuardRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new FemaleGuardModel(context.m_174023_(FemaleGuardModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new FemaleGuardArmorModel(context.m_174023_(FemaleGuardArmorModel.INNER_LAYER_LOCATION)), (HumanoidModel)new FemaleGuardArmorModel(context.m_174023_(FemaleGuardArmorModel.OUTER_LAYER_LOCATION))));
    }

    public void render(FemaleGuard entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void setModelVisibilities(FemaleGuard entityIn) {
        HumanoidModel guardModel = (HumanoidModel)this.m_7200_();
        ItemStack mainHandItem = entityIn.m_21205_();
        ItemStack offhandItem = entityIn.m_21206_();
        guardModel.m_8009_(true);
        HumanoidModel.ArmPose mainHandPose = this.getArmPose(entityIn, mainHandItem, offhandItem, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose offhandPose = this.getArmPose(entityIn, mainHandItem, offhandItem, InteractionHand.OFF_HAND);
        guardModel.f_102817_ = entityIn.m_6047_();
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            guardModel.f_102816_ = mainHandPose;
            guardModel.f_102815_ = offhandPose;
        } else {
            guardModel.f_102816_ = offhandPose;
            guardModel.f_102815_ = mainHandPose;
        }
    }

    private HumanoidModel.ArmPose getArmPose(FemaleGuard entity, ItemStack mainHandItem, ItemStack offhandItem, InteractionHand hand) {
        ItemStack itemInHand;
        HumanoidModel.ArmPose armPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemStack = itemInHand = hand == InteractionHand.MAIN_HAND ? mainHandItem : offhandItem;
        if (!itemInHand.m_41619_()) {
            armPose = HumanoidModel.ArmPose.ITEM;
            if (entity.m_21212_() > 0) {
                UseAnim useAnimation = itemInHand.m_41780_();
                armPose = this.getArmPoseForAnimation(useAnimation, hand == entity.m_7655_());
            } else {
                boolean hasCrossbowInOffhand;
                boolean hasCrossbowInMainHand = mainHandItem.m_41720_() instanceof CrossbowItem;
                if (hasCrossbowInMainHand && entity.m_5912_()) {
                    armPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                }
                if ((hasCrossbowInOffhand = offhandItem.m_41720_() instanceof CrossbowItem) && mainHandItem.m_41720_().m_6164_(mainHandItem) == UseAnim.NONE && entity.m_5912_()) {
                    armPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                }
            }
        }
        return armPose;
    }

    public HumanoidModel.ArmPose getArmPoseForAnimation(UseAnim useAnimation, boolean usingMainHand) {
        return switch (useAnimation) {
            case UseAnim.BLOCK -> HumanoidModel.ArmPose.BLOCK;
            case UseAnim.BOW -> HumanoidModel.ArmPose.BOW_AND_ARROW;
            case UseAnim.SPEAR -> HumanoidModel.ArmPose.THROW_SPEAR;
            case UseAnim.CROSSBOW -> {
                if (usingMainHand) {
                    yield HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                }
            }
            default -> HumanoidModel.ArmPose.EMPTY;
        };
    }

    protected void scale(FemaleGuard entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float defaultScale = 0.9375f;
        matrixStackIn.m_85841_(defaultScale, defaultScale, defaultScale);
    }

    @Nullable
    public ResourceLocation getTextureLocation(FemaleGuard entity) {
        return new ResourceLocation("femalevillagers", "textures/entity/female_guard/guard_" + entity.getGuardVariant() + ".png");
    }
}

