/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.theconjurer;

import com.legacy.conjurer_illager.entity.ConjurerEntity;
import daripher.femalevillagers.compat.theconjurer.client.model.FemaleConjurerModel;
import daripher.femalevillagers.compat.theconjurer.client.render.FemaleConjurerRenderer;
import daripher.femalevillagers.compat.theconjurer.entity.FemaleConjurer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public enum TheConjurerCompatibility {
    INSTANCE;

    private static final ResourceLocation FEMALE_CONJURER_ENTITY_ID;

    public void addCompatibility() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::createAttributes);
        modEventBus.addListener(this::registerEntityType);
        modEventBus.addListener(this::registerRenderer);
    }

    public Entity createFemaleConjurer(Entity entity) {
        return new FemaleConjurer(entity.f_19853_);
    }

    public EntityType<FemaleConjurer> getFemaleConjurerEntityType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(FEMALE_CONJURER_ENTITY_ID);
    }

    private void createAttributes(EntityAttributeCreationEvent event) {
        event.put(this.getFemaleConjurerEntityType(), ConjurerEntity.registerAttributes().m_22265_());
    }

    private void registerEntityType(RegisterEvent event) {
        event.register(Registries.f_256939_, FEMALE_CONJURER_ENTITY_ID, FemaleConjurer::createEntityType);
    }

    private void registerRenderer(FMLClientSetupEvent event) {
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)FemaleConjurerModel.LAYER_LOCATION, FemaleConjurerModel::createBodyLayer);
        EntityRenderers.m_174036_(this.getFemaleConjurerEntityType(), FemaleConjurerRenderer::new);
    }

    static {
        FEMALE_CONJURER_ENTITY_ID = new ResourceLocation("femalevillagers", "female_conjurer");
    }
}

