/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.vampirism;

import daripher.femalevillagers.client.render.FemaleVillagerRenderer;
import daripher.femalevillagers.compat.vampirism.entity.FemaleConvertedVillager;
import daripher.femalevillagers.init.EntityInit;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public enum VampirismCompatibility {
    INSTANCE;

    private static final ResourceLocation FEMALE_CONVERTED_VILLAGER_ENTITY_ID;

    public void addCompatibility() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::createAttributes);
        modEventBus.addListener(this::registerEntityType);
        modEventBus.addListener(this::registerRenderer);
        modEventBus.addListener(this::registerConvertionHandler);
    }

    private void registerConvertionHandler(FMLCommonSetupEvent event) {
        EntityType entityType = (EntityType)EntityInit.FEMALE_VILLAGER.get();
        ResourceLocation overlayTexture = new ResourceLocation("femalevillagers", "textures/vampirism/female_villager_overlay.png");
        FemaleConvertedVillager.ConvertingHandler handler = new FemaleConvertedVillager.ConvertingHandler();
        VampirismAPI.entityRegistry().addConvertible(entityType, overlayTexture, (IConvertingHandler)handler);
    }

    private void createAttributes(EntityAttributeCreationEvent event) {
        event.put(this.getFemaleConvertedVillagerEntityType(), FemaleConvertedVillager.getAttributeBuilder().m_22265_());
    }

    private void registerEntityType(RegisterEvent event) {
        event.register(Registries.f_256939_, FEMALE_CONVERTED_VILLAGER_ENTITY_ID, this::createFemaleConvertedVillagerEntityType);
    }

    private EntityType<FemaleConvertedVillager> createFemaleConvertedVillagerEntityType() {
        return EntityType.Builder.m_20704_(FemaleConvertedVillager::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f).setShouldReceiveVelocityUpdates(true).m_20712_("female_converted_villager");
    }

    private void registerRenderer(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_(this.getFemaleConvertedVillagerEntityType(), ctx -> new FemaleVillagerRenderer(ctx, "vampirism/female_villager"));
    }

    public EntityType<FemaleConvertedVillager> getFemaleConvertedVillagerEntityType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(FEMALE_CONVERTED_VILLAGER_ENTITY_ID);
    }

    static {
        FEMALE_CONVERTED_VILLAGER_ENTITY_ID = new ResourceLocation("femalevillagers", "female_converted_villager");
    }
}

