/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.compat.villagernames;

import com.google.gson.JsonSyntaxException;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.JsonFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.villagernames_common_forge.config.ConfigHandler;
import com.natamus.villagernames_common_forge.util.Names;
import daripher.femalevillagers.entity.FemaleVillager;
import daripher.femalevillagers.init.EntityInit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public enum VillagerNamesCompatibility {
    INSTANCE;

    private static List<String> customFemaleNames;

    public void addCompatibility() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initCustomFemaleNames);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::setVillagerName);
        MinecraftForge.EVENT_BUS.addListener(this::setFemaleVillagerNameInGUI);
    }

    private void setVillagerName(EntityJoinLevelEvent event) {
        if (!this.shouldHaveName(event.getEntity())) {
            return;
        }
        boolean isFemale = this.isFemaleEntity(event.getEntity());
        String entityName = this.getRandomVillagerName(isFemale);
        EntityFunctions.nameEntity((Entity)event.getEntity(), (String)entityName);
    }

    private void setFemaleVillagerNameInGUI(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget().m_6095_() != EntityInit.FEMALE_VILLAGER.get()) {
            return;
        }
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!event.getTarget().m_8077_()) {
            return;
        }
        if (event.getEntity().m_6047_()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        FemaleVillager villager = (FemaleVillager)event.getTarget();
        VillagerData villagerData = villager.m_7141_();
        String villagerProfession = villagerData.m_35571_().toString();
        if (villagerProfession.equals("none") || villagerProfession.equals("nitwit")) {
            return;
        }
        if (villagerProfession.contains(":")) {
            villagerProfession = villagerProfession.split(":")[1];
        }
        if (villagerProfession.contains("-")) {
            villagerProfession = villagerProfession.split("-")[0].trim();
        }
        Component villagerName = villager.m_7755_();
        try {
            String nameJson = Component.Serializer.m_130703_((Component)villagerName);
            HashMap nameComponentMap = JsonFunctions.JsonStringToHashMap((String)nameJson);
            String prevName = (String)nameComponentMap.get("text");
            String formattedProfession = villagerProfession.substring(0, 1).toUpperCase() + villagerProfession.substring(1);
            if (prevName.contains(formattedProfession)) {
                return;
            }
            nameComponentMap.put("text", prevName + " the " + formattedProfession);
            villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)nameComponentMap)));
            new Thread(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                nameComponentMap.put("text", prevName.replace(" the ", "").replace(formattedProfession, ""));
                villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)nameComponentMap)));
            }).start();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
    }

    private void initCustomFemaleNames(FMLLoadCompleteEvent event) {
        String configDirectoryPath = DataFunctions.getConfigDirectory() + File.separator + "villagernames";
        File configDirectory = new File(configDirectoryPath);
        File configFile = new File(configDirectoryPath + File.separator + "customfemalenames.txt");
        if (configDirectory.isDirectory() && configFile.isFile()) {
            String[] customNames = this.readCustomFemaleNames(configDirectoryPath);
            customFemaleNames = Arrays.asList(customNames);
        } else {
            configDirectory.mkdirs();
            this.writeCustomFemaleNames(configDirectoryPath);
            customFemaleNames = new ArrayList<String>(Arrays.asList("Olivia", "Emma", "Charlotte"));
        }
    }

    private boolean shouldHaveName(Entity entity) {
        if (!ModList.get().isLoaded("villagernames")) {
            return false;
        }
        if (entity.f_19853_.f_46443_) {
            return false;
        }
        if (entity.m_8077_()) {
            return false;
        }
        if (EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals("femalevillagers:female_guard")) {
            return true;
        }
        if (entity.m_6095_() == EntityInit.FEMALE_WANDERING_TRADER.get()) {
            return true;
        }
        if (!(entity instanceof Villager)) {
            boolean shouldHaveName = false;
            if (ConfigHandler.nameModdedVillagers && EntityFunctions.isModdedVillager((Entity)entity)) {
                shouldHaveName = true;
            }
            if (!shouldHaveName) {
                return false;
            }
        }
        return true;
    }

    private boolean isFemaleEntity(Entity entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135827_().equals("femalevillagers");
    }

    private String getRandomVillagerName(boolean isFemale) {
        boolean usePredefinedNames = isFemale ? ConfigHandler._useFemaleNames : ConfigHandler._useMaleNames;
        boolean useCustomNames = ConfigHandler._useCustomNames;
        List predefinedNames = isFemale ? GlobalVariables.femalenames : GlobalVariables.malenames;
        List customNames = isFemale ? customFemaleNames : Names.customnames;
        return this.getRandomVillagerName(usePredefinedNames, useCustomNames, predefinedNames, customNames);
    }

    private String getRandomVillagerName(boolean usePredefinedNames, boolean useCustomNames, List<String> predefinedNames, List<String> customNames) {
        List<String> names = null;
        if (usePredefinedNames) {
            names = predefinedNames;
        }
        if (useCustomNames && customNames != null) {
            names = names == null ? customNames : Stream.concat(customNames.stream(), names.stream()).collect(Collectors.toList());
        }
        if (names == null) {
            return "";
        }
        String name = names.get(GlobalVariables.random.nextInt(names.size())).toLowerCase();
        return StringFunctions.capitalizeEveryWord((String)name);
    }

    private String[] readCustomFemaleNames(String configDirectoryPath) {
        String customNamesString = null;
        try {
            customNamesString = Files.readString(Paths.get(configDirectoryPath + File.separator + "customfemalenames.txt", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        customNamesString = customNamesString.replace("\n", "").replace("\r", "");
        return customNamesString.split(",");
    }

    private void writeCustomFemaleNames(String configDirectoryPath) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(configDirectoryPath + File.separator + "customfemalenames.txt", StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writer.println("Olivia,");
        writer.println("Emma,");
        writer.println("Charlotte");
        writer.close();
    }

    static {
        customFemaleNames = null;
    }
}

