/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.event;

import daripher.femalevillagers.compat.guardvillagers.GuardVillagersCompatibility;
import daripher.femalevillagers.compat.theconjurer.TheConjurerCompatibility;
import daripher.femalevillagers.entity.FemaleEvoker;
import daripher.femalevillagers.entity.FemaleIllusioner;
import daripher.femalevillagers.entity.FemalePillager;
import daripher.femalevillagers.entity.FemaleVillager;
import daripher.femalevillagers.entity.FemaleVindicator;
import daripher.femalevillagers.entity.FemaleWanderingTrader;
import daripher.femalevillagers.entity.FemaleZombieVillager;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="femalevillagers")
public class FemaleVillagersEvents {
    @SubscribeEvent
    public static void replaceVillagerWithFemaleVersion(EntityJoinLevelEvent event) {
        if (event.getEntity().m_19880_().contains("do_not_replace")) {
            return;
        }
        if (event.getEntity().f_19853_.f_46443_ || event.loadedFromDisk()) {
            return;
        }
        Level level = event.getLevel();
        double replaceChance = 0.5;
        if ((double)level.f_46441_.m_188501_() >= replaceChance) {
            return;
        }
        Entity replacementEntity = FemaleVillagersEvents.createReplacementEntity(event.getEntity());
        if (replacementEntity != null) {
            level.m_7967_(replacementEntity);
            event.setCanceled(true);
        }
    }

    @Nullable
    private static Entity createReplacementEntity(Entity entity) {
        VillagerData villagerData;
        Villager replacedEntity;
        Raider raider;
        if (entity instanceof Raider && (raider = (Raider)entity).m_37885_() != null) {
            return null;
        }
        Object replacementEntity = null;
        if (entity.m_6095_() == EntityType.f_20492_) {
            replacementEntity = new FemaleVillager(entity.f_19853_);
            replacedEntity = (Villager)entity;
            villagerData = replacedEntity.m_7141_();
            replacementEntity.m_34375_(villagerData);
            replacementEntity.m_6863_(replacedEntity.m_6162_());
        }
        if (entity.m_6095_() == EntityType.f_20530_) {
            replacementEntity = new FemaleZombieVillager(entity.f_19853_);
            replacedEntity = (ZombieVillager)entity;
            villagerData = replacedEntity.m_7141_();
            ((FemaleZombieVillager)((Object)replacementEntity)).m_34375_(villagerData);
            ((FemaleZombieVillager)((Object)replacementEntity)).m_6863_(replacedEntity.m_6162_());
        }
        if (entity.m_6095_() == EntityType.f_20494_) {
            replacementEntity = new FemaleWanderingTrader(entity.f_19853_);
        }
        if (entity.m_6095_() == EntityType.f_20513_) {
            replacedEntity = (Pillager)entity;
            replacementEntity = new FemalePillager(entity.f_19853_);
            replacementEntity.m_8061_(EquipmentSlot.MAINHAND, replacedEntity.m_6844_(EquipmentSlot.MAINHAND));
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack itemInSlot = replacedEntity.m_35311_().m_8020_(slot);
                ((FemalePillager)((Object)replacementEntity)).m_35311_().m_6836_(slot, itemInSlot);
            }
        }
        if (entity.m_6095_() == EntityType.f_20568_) {
            replacementEntity = new FemaleEvoker(entity.f_19853_);
        }
        if (entity.m_6095_() == EntityType.f_20493_) {
            replacedEntity = (Vindicator)entity;
            replacementEntity = new FemaleVindicator(entity.f_19853_);
            replacementEntity.m_8061_(EquipmentSlot.MAINHAND, replacedEntity.m_6844_(EquipmentSlot.MAINHAND));
        }
        if (entity.m_6095_() == EntityType.f_20459_) {
            replacedEntity = (Illusioner)entity;
            replacementEntity = new FemaleIllusioner(entity.f_19853_);
            replacementEntity.m_8061_(EquipmentSlot.MAINHAND, replacedEntity.m_6844_(EquipmentSlot.MAINHAND));
        }
        if (EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals("guardvillagers:guard")) {
            replacementEntity = GuardVillagersCompatibility.INSTANCE.createFemaleGuard(entity);
        }
        if (EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals("conjurer_illager:conjurer")) {
            replacementEntity = TheConjurerCompatibility.INSTANCE.createFemaleConjurer(entity);
        }
        if (replacementEntity != null) {
            replacementEntity.m_146884_(entity.m_20182_());
        }
        return replacementEntity;
    }
}

