/*
 * Decompiled with CFR 0.152.
 */
package daripher.femalevillagers.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.femalevillagers.config.Config;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.npc.Villager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerModel.class})
public class MixinVillagerModel
implements ArmedModel {
    protected ModelPart rightArm;
    protected ModelPart leftArm;
    protected ModelPart arms;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="TAIL")})
    private void initArms(ModelPart root, CallbackInfo callbackInfo) {
        try {
            this.rightArm = root.m_171324_("right_arm");
            this.leftArm = root.m_171324_("left_arm");
            this.arms = root.m_171324_("arms");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"createBodyModel"}, at={@At(value="RETURN")})
    private static void createArms(CallbackInfoReturnable<MeshDefinition> callbackInfo) {
        MeshDefinition model = (MeshDefinition)callbackInfo.getReturnValue();
        PartDefinition root = model.m_171576_();
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-1.5f, -2.5f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-6.5f, (float)3.0f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("cube_1", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171488_(-1.5f, -2.0f, -4.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.5f, (float)7.0f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)-1.5708f));
        rightArm.m_171599_("cube_2", CubeListBuilder.m_171558_().m_171514_(40, 42).m_171488_(-1.0f, -1.5f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171514_(36, 38).m_171480_().m_171488_(-1.0f, -1.5f, -4.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)8.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)1.5708f));
        rightArm.m_171599_("cube_3", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-1.0f, -4.0f, -2.5f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)8.5f, (float)-2.0f, (float)1.5708f, (float)3.1416f, (float)1.5708f));
        rightArm.m_171599_("cube_4", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171488_(-3.0f, -4.0f, -1.5f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)8.5f, (float)-2.0f, (float)1.5708f, (float)3.1416f, (float)-1.5708f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)2.5f, (float)0.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("cube_5", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-2.5f, -4.0f, -1.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)7.5f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)-1.5708f));
        leftArm.m_171599_("cube_6", CubeListBuilder.m_171558_().m_171514_(40, 42).m_171480_().m_171488_(-1.5f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)7.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)-1.5708f));
        leftArm.m_171599_("cube_7", CubeListBuilder.m_171558_().m_171514_(36, 38).m_171488_(-1.0f, -0.5f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.5f, (float)9.0f, (float)-2.0f, (float)3.1416f, (float)3.1416f, (float)1.5708f));
        leftArm.m_171599_("cube_8", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-1.0f, -3.5f, -4.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)9.0f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)1.5708f));
        leftArm.m_171599_("cube_9", CubeListBuilder.m_171558_().m_171514_(52, 38).m_171480_().m_171488_(-1.0f, 0.0f, -3.5f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)9.0f, (float)-2.0f, (float)-1.5708f, (float)3.1416f, (float)1.5708f));
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    private void setupArmsAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        if (this.rightArm == null) {
            return;
        }
        if (!(entity instanceof Villager)) {
            this.leftArm.f_104207_ = false;
            this.rightArm.f_104207_ = false;
            this.arms.f_104207_ = true;
            return;
        }
        if (((Boolean)Config.COMMON.useDefaultVillagerArms.get()).booleanValue()) {
            this.leftArm.f_104207_ = false;
            this.rightArm.f_104207_ = false;
        } else {
            this.arms.f_104207_ = false;
        }
        Villager villager = (Villager)entity;
        boolean isFalling = villager.m_21256_() > 4;
        float f = 1.0f;
        if (isFalling) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        ModelPart modelpart = this.getArm(arm);
        float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
        modelpart.f_104200_ += f;
        modelpart.m_104299_(poseStack);
        modelpart.f_104200_ -= f;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }
}

