/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ModConfig;
import com.jaquadro.minecraft.hungerstrike.network.PacketHandler;
import com.jaquadro.minecraft.hungerstrike.network.PacketSyncExtendedPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;

public class ExtendedPlayer {
    public static final ResourceLocation EXTENDED_PLAYER_KEY = new ResourceLocation("hungerstrike:extended_player");
    public static Capability<ExtendedPlayer> EXTENDED_PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ExtendedPlayer>(){});
    private final Player player;
    private boolean hungerStrikeEnabled;
    private int startHunger;

    public ExtendedPlayer(Player player) {
        this.player = player;
        this.hungerStrikeEnabled = false;
    }

    public static ExtendedPlayer get(Player player) {
        if (EXTENDED_PLAYER_CAPABILITY == null) {
            return null;
        }
        return (ExtendedPlayer)player.getCapability(EXTENDED_PLAYER_CAPABILITY, null).orElse(null);
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128379_("Enabled", this.hungerStrikeEnabled);
    }

    public void loadNBTData(CompoundTag compound) {
        this.hungerStrikeEnabled = compound.m_128471_("Enabled");
    }

    public void enableHungerStrike(boolean enable) {
        if (this.hungerStrikeEnabled != enable) {
            this.hungerStrikeEnabled = enable;
            if (this.player instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)this.player;
                PacketHandler.INSTANCE.sendTo((Object)new PacketSyncExtendedPlayer(this.player), playerMP.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void loadState(boolean hungerStrikeEnabled) {
        this.hungerStrikeEnabled = hungerStrikeEnabled;
    }

    public boolean isOnHungerStrike() {
        return this.hungerStrikeEnabled;
    }

    private boolean shouldTick() {
        ModConfig.Mode mode = (ModConfig.Mode)((Object)ModConfig.GENERAL.mode.get());
        if (mode == ModConfig.Mode.LIST) {
            return this.hungerStrikeEnabled;
        }
        return mode == ModConfig.Mode.ALL;
    }

    public void tick(TickEvent.Phase phase, LogicalSide side) {
        if (!this.shouldTick()) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            this.tickStart();
        } else if (phase == TickEvent.Phase.END) {
            this.tickEnd(side);
        }
    }

    private void tickStart() {
        this.setFoodData(this.player.m_36324_(), this.calcBaselineHunger(), 1.0f);
        this.startHunger = this.player.m_36324_().m_38702_();
    }

    private void tickEnd(LogicalSide side) {
        int foodDiff;
        if (side == LogicalSide.SERVER && (foodDiff = this.player.m_36324_().m_38702_() - this.startHunger) > 0) {
            this.player.m_5634_((float)((double)foodDiff * (Double)ModConfig.GENERAL.foodHealFactor.get()));
        }
        this.setFoodData(this.player.m_36324_(), this.calcBaselineHunger(), 1.0f);
    }

    private void setFoodData(FoodData foodStats, int foodLevel, float saturationLevel) {
        foodStats.m_38707_(1, (saturationLevel - foodStats.m_38722_()) / 2.0f);
        foodStats.m_38707_(foodLevel - foodStats.m_38702_(), 0.0f);
    }

    private int calcBaselineHunger() {
        if (this.player.m_21023_(MobEffects.f_19612_)) {
            return 5;
        }
        if (this.player.m_21023_(MobEffects.f_19605_)) {
            return 20;
        }
        return (Integer)ModConfig.GENERAL.hungerBaseline.get();
    }
}

