/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.command;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ModConfig;
import com.jaquadro.minecraft.hungerstrike.PlayerHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;

public class HungerStrikeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hungerstrike").requires(req -> req.m_6761_(3))).then(Commands.m_82127_((String)"list").executes(command -> HungerStrikeCommand.listPlayers((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).suggests((command, t) -> {
            PlayerList players = ((CommandSourceStack)command.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(players.m_11314_().stream().filter(entity -> {
                ExtendedPlayer player = ExtendedPlayer.get((Player)entity);
                return player != null && !player.isOnHungerStrike();
            }).map(entity -> entity.m_36316_().getName()), (SuggestionsBuilder)t);
        }).executes(command -> HungerStrikeCommand.addPlayers((CommandSourceStack)command.getSource(), GameProfileArgument.m_94590_((CommandContext)command, (String)"targets")))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).suggests((command, t) -> {
            PlayerList players = ((CommandSourceStack)command.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(players.m_11314_().stream().filter(entity -> {
                ExtendedPlayer player = ExtendedPlayer.get((Player)entity);
                return player != null && player.isOnHungerStrike();
            }).map(entity -> entity.m_36316_().getName()), (SuggestionsBuilder)t);
        }).executes(command -> HungerStrikeCommand.removePlayers((CommandSourceStack)command.getSource(), GameProfileArgument.m_94590_((CommandContext)command, (String)"targets")))))).then(Commands.m_82127_((String)"mode").executes(command -> HungerStrikeCommand.getMode((CommandSourceStack)command.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setmode").then(Commands.m_82127_((String)"none").executes(command -> HungerStrikeCommand.setMode((CommandSourceStack)command.getSource(), ModConfig.Mode.NONE)))).then(Commands.m_82127_((String)"list").executes(command -> HungerStrikeCommand.setMode((CommandSourceStack)command.getSource(), ModConfig.Mode.LIST)))).then(Commands.m_82127_((String)"all").executes(command -> HungerStrikeCommand.setMode((CommandSourceStack)command.getSource(), ModConfig.Mode.ALL)))));
    }

    private static int listPlayers(CommandSourceStack source) {
        List<String> players = HungerStrikeCommand.playersToNames(PlayerHandler.getStrikingPlayers(source.m_81377_()));
        if (players.size() == 0) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.list.none"), false);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.list", new Object[]{players.size(), String.join((CharSequence)", ", players)}), false);
        }
        return players.size();
    }

    private static int addPlayers(CommandSourceStack source, Collection<GameProfile> playerProfiles) {
        int addedCount = 0;
        for (GameProfile profile : playerProfiles) {
            ExtendedPlayer player = ExtendedPlayer.get((Player)source.m_81377_().m_6846_().m_11259_(profile.getId()));
            if (player == null || player.isOnHungerStrike()) continue;
            player.enableHungerStrike(true);
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.add.success", new Object[]{ComponentUtils.m_130727_((GameProfile)profile)}), true);
            ++addedCount;
        }
        return addedCount;
    }

    private static int removePlayers(CommandSourceStack source, Collection<GameProfile> playerProfiles) {
        int removedCount = 0;
        for (GameProfile profile : playerProfiles) {
            ExtendedPlayer player = ExtendedPlayer.get((Player)source.m_81377_().m_6846_().m_11259_(profile.getId()));
            if (player == null || !player.isOnHungerStrike()) continue;
            player.enableHungerStrike(false);
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.remove.success", new Object[]{ComponentUtils.m_130727_((GameProfile)profile)}), true);
            ++removedCount;
        }
        return removedCount;
    }

    private static int getMode(CommandSourceStack source) {
        ModConfig.Mode mode = (ModConfig.Mode)((Object)ModConfig.GENERAL.mode.get());
        if (mode == ModConfig.Mode.NONE) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.mode.none"), false);
        } else if (mode == ModConfig.Mode.LIST) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.mode.list"), false);
        } else if (mode == ModConfig.Mode.ALL) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.mode.all"), false);
        }
        return 1;
    }

    private static int setMode(CommandSourceStack source, ModConfig.Mode mode) {
        ModConfig.GENERAL.mode.set((Object)mode);
        if (mode == ModConfig.Mode.NONE) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.setmode.none"), true);
        } else if (mode == ModConfig.Mode.LIST) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.setmode.list"), true);
        } else if (mode == ModConfig.Mode.ALL) {
            source.m_81354_((Component)new TranslatableComponent("commands.hungerstrike.setmode.all"), true);
        }
        return 1;
    }

    private static List<String> playersToNames(List<Player> players) {
        ArrayList<String> playerNames = new ArrayList<String>(players.size());
        for (Player player : players) {
            playerNames.add(player.m_7755_().getString());
        }
        return playerNames;
    }
}

