/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.network;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncExtendedPlayer {
    private boolean hungerStrikeEnabled;

    public static void encode(PacketSyncExtendedPlayer msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.hungerStrikeEnabled);
    }

    public static PacketSyncExtendedPlayer decode(FriendlyByteBuf buf) {
        return new PacketSyncExtendedPlayer(buf.readBoolean());
    }

    private PacketSyncExtendedPlayer(boolean hungerStrikeEnabled) {
        this.hungerStrikeEnabled = hungerStrikeEnabled;
    }

    public PacketSyncExtendedPlayer(Player player) {
        this(PacketSyncExtendedPlayer.getHungerStrikeFromPlayer(player));
    }

    private static boolean getHungerStrikeFromPlayer(Player player) {
        ExtendedPlayer ep = ExtendedPlayer.get(player);
        return ep != null && ep.isOnHungerStrike();
    }

    public static void handle(PacketSyncExtendedPlayer message, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncExtendedPlayer.lambda$handle$0(message, (Supplier)ctx));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(PacketSyncExtendedPlayer message, ServerPlayer mp) {
        ExtendedPlayer ep = ExtendedPlayer.get((Player)mp);
        if (ep != null) {
            ep.loadState(message.hungerStrikeEnabled);
        }
    }

    private static /* synthetic */ void lambda$handle$0(PacketSyncExtendedPlayer message, Supplier ctx) {
        PacketSyncExtendedPlayer.handle(message, ((NetworkEvent.Context)ctx.get()).getSender());
    }
}

