/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ExtendedPlayerProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final ExtendedPlayer extendedPlayer;
    private LazyOptional<?> playerHandler;

    public ExtendedPlayerProvider(Player player) {
        this.extendedPlayer = new ExtendedPlayer(player);
        this.playerHandler = LazyOptional.of(() -> this.extendedPlayer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == ExtendedPlayerHandler.EXTENDED_PLAYER_CAPABILITY ? this.playerHandler.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.extendedPlayer.saveNBTData(compound);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.extendedPlayer.loadNBTData(nbt);
    }
}

