/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.proxy;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayerProvider;
import com.jaquadro.minecraft.hungerstrike.PlayerHandler;
import com.jaquadro.minecraft.hungerstrike.command.HungerStrikeCommand;
import com.jaquadro.minecraft.hungerstrike.network.PacketHandler;
import com.jaquadro.minecraft.hungerstrike.network.PacketRequestSync;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonProxy {
    public PlayerHandler playerHandler = new PlayerHandler();

    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerNetworkHandlers() {
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        this.playerHandler.tick(event.player, event.phase, event.side);
    }

    @SubscribeEvent
    public void attachCapabilites(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(ExtendedPlayer.EXTENDED_PLAYER_KEY, (ICapabilityProvider)new ExtendedPlayerProvider((Player)event.getObject()));
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_20193_().f_46443_ && entity instanceof ServerPlayer) {
            this.playerHandler.storeData((Player)entity);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!event.getLevel().f_46443_ && entity instanceof ServerPlayer) {
            this.playerHandler.restoreData((Player)entity);
        } else if (event.getLevel().f_46443_ && entity instanceof ServerPlayer) {
            PacketHandler.INSTANCE.sendToServer((Object)new PacketRequestSync());
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        HungerStrikeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

