/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.network;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class SyncExtendedPlayerMessage
implements IMessage {
    public static final int MESSAGE_ID = 0;
    private NBTTagCompound data;

    public SyncExtendedPlayerMessage() {
    }

    public SyncExtendedPlayerMessage(EntityPlayer player) {
        this.data = new NBTTagCompound();
        ExtendedPlayer ep = ExtendedPlayer.get(player);
        if (ep != null) {
            ep.saveNBTDataSync(this.data);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class HandlerStub
    implements IMessageHandler<SyncExtendedPlayerMessage, IMessage> {
        public IMessage onMessage(SyncExtendedPlayerMessage message, MessageContext ctx) {
            FMLLog.log((String)"hungerstrike", (Level)Level.WARN, (String)"SyncExtendedPlayerMessage stub handler called.", (Object[])new Object[0]);
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IMessageHandler<SyncExtendedPlayerMessage, IMessage> {
        public IMessage onMessage(SyncExtendedPlayerMessage message, MessageContext ctx) {
            ExtendedPlayer ep;
            if (ctx.side == Side.CLIENT && (ep = ExtendedPlayer.get((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity())) != null) {
                ep.loadNBTData(message.data);
            }
            return null;
        }
    }
}

