/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ConfigManager;
import com.jaquadro.minecraft.hungerstrike.HungerStrike;
import com.jaquadro.minecraft.hungerstrike.network.SyncExtendedPlayerMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ExtendedPlayer {
    public static final ResourceLocation EXTENDED_PLAYER_KEY = new ResourceLocation("HungerStrike:ExtendedPlayer");
    @CapabilityInject(value=ExtendedPlayer.class)
    public static Capability<ExtendedPlayer> EXTENDED_PLAYER_CAPABILITY;
    private final EntityPlayer player;
    private boolean hungerStrikeEnabled;
    private int startHunger;

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.hungerStrikeEnabled = false;
    }

    public static ExtendedPlayer get(EntityPlayer player) {
        if (EXTENDED_PLAYER_CAPABILITY == null) {
            return null;
        }
        return (ExtendedPlayer)player.getCapability(EXTENDED_PLAYER_CAPABILITY, null);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74757_a("Enabled", this.hungerStrikeEnabled);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.hungerStrikeEnabled = compound.func_74767_n("Enabled");
    }

    public void saveNBTDataSync(NBTTagCompound compound) {
        compound.func_74757_a("Enabled", this.hungerStrikeEnabled);
    }

    public void enableHungerStrike(boolean enable) {
        if (this.hungerStrikeEnabled != enable) {
            this.hungerStrikeEnabled = enable;
            if (this.player instanceof EntityPlayerMP) {
                HungerStrike.network.sendTo((IMessage)new SyncExtendedPlayerMessage(this.player), (EntityPlayerMP)this.player);
            }
        }
    }

    public boolean isOnHungerStrike() {
        return this.hungerStrikeEnabled;
    }

    private boolean shouldTick() {
        ConfigManager.Mode mode = HungerStrike.config.getMode();
        if (mode == ConfigManager.Mode.LIST) {
            return this.hungerStrikeEnabled;
        }
        return mode == ConfigManager.Mode.ALL;
    }

    public void tick(TickEvent.Phase phase, Side side) {
        if (!this.shouldTick()) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            this.tickStart();
        } else if (phase == TickEvent.Phase.END) {
            this.tickEnd(side);
        }
    }

    private void tickStart() {
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
        this.startHunger = this.player.func_71024_bL().func_75116_a();
    }

    private void tickEnd(Side side) {
        int foodDiff;
        if (side == Side.SERVER && (foodDiff = this.player.func_71024_bL().func_75116_a() - this.startHunger) > 0) {
            this.player.func_70691_i((float)foodDiff * (float)HungerStrike.config.getFoodHealFactor());
        }
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
    }

    private void setFoodData(FoodStats foodStats, int foodLevel, float saturationLevel) {
        foodStats.func_75122_a(1, (saturationLevel - foodStats.func_75115_e()) / 2.0f);
        foodStats.func_75122_a(foodLevel - foodStats.func_75116_a(), 0.0f);
    }

    private int calcBaselineHunger() {
        if (this.player.func_70644_a(Potion.func_180142_b((String)"hunger"))) {
            return 5;
        }
        if (this.player.func_70644_a(Potion.func_180142_b((String)"regeneration"))) {
            return 20;
        }
        return HungerStrike.config.getHungerBaseline();
    }
}

