/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ModConfig;
import com.jaquadro.minecraft.hungerstrike.network.PacketHandler;
import com.jaquadro.minecraft.hungerstrike.network.PacketSyncExtendedPlayer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;

public class ExtendedPlayer {
    public static final ResourceLocation EXTENDED_PLAYER_KEY = new ResourceLocation("hungerstrike:extended_player");
    @CapabilityInject(value=ExtendedPlayer.class)
    public static Capability<ExtendedPlayer> EXTENDED_PLAYER_CAPABILITY;
    private final PlayerEntity player;
    private boolean hungerStrikeEnabled;
    private int startHunger;

    public ExtendedPlayer(PlayerEntity player) {
        this.player = player;
        this.hungerStrikeEnabled = false;
    }

    public static ExtendedPlayer get(PlayerEntity player) {
        if (EXTENDED_PLAYER_CAPABILITY == null) {
            return null;
        }
        return (ExtendedPlayer)player.getCapability(EXTENDED_PLAYER_CAPABILITY, null).orElse(null);
    }

    public void saveNBTData(CompoundNBT compound) {
        compound.func_74757_a("Enabled", this.hungerStrikeEnabled);
    }

    public void loadNBTData(CompoundNBT compound) {
        this.hungerStrikeEnabled = compound.func_74767_n("Enabled");
    }

    public void enableHungerStrike(boolean enable) {
        if (this.hungerStrikeEnabled != enable) {
            this.hungerStrikeEnabled = enable;
            if (this.player instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerMP = (ServerPlayerEntity)this.player;
                PacketHandler.INSTANCE.sendTo((Object)new PacketSyncExtendedPlayer(this.player), playerMP.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void loadState(boolean hungerStrikeEnabled) {
        this.hungerStrikeEnabled = hungerStrikeEnabled;
    }

    public boolean isOnHungerStrike() {
        return this.hungerStrikeEnabled;
    }

    private boolean shouldTick() {
        ModConfig.Mode mode = (ModConfig.Mode)((Object)ModConfig.GENERAL.mode.get());
        if (mode == ModConfig.Mode.LIST) {
            return this.hungerStrikeEnabled;
        }
        return mode == ModConfig.Mode.ALL;
    }

    public void tick(TickEvent.Phase phase, LogicalSide side) {
        if (!this.shouldTick()) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            this.tickStart();
        } else if (phase == TickEvent.Phase.END) {
            this.tickEnd(side);
        }
    }

    private void tickStart() {
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
        this.startHunger = this.player.func_71024_bL().func_75116_a();
    }

    private void tickEnd(LogicalSide side) {
        int foodDiff;
        if (side == LogicalSide.SERVER && (foodDiff = this.player.func_71024_bL().func_75116_a() - this.startHunger) > 0) {
            this.player.func_70691_i((float)((double)foodDiff * (Double)ModConfig.GENERAL.foodHealFactor.get()));
        }
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
    }

    private void setFoodData(FoodStats foodStats, int foodLevel, float saturationLevel) {
        foodStats.func_75122_a(1, (saturationLevel - foodStats.func_75115_e()) / 2.0f);
        foodStats.func_75122_a(foodLevel - foodStats.func_75116_a(), 0.0f);
    }

    private int calcBaselineHunger() {
        if (this.player.func_70644_a(Effects.field_76438_s)) {
            return 5;
        }
        if (this.player.func_70644_a(Effects.field_76428_l)) {
            return 20;
        }
        return (Integer)ModConfig.GENERAL.hungerBaseline.get();
    }
}

