/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerHandler {
    private static final Map<GameProfile, Map<String, CompoundNBT>> dataStore = new HashMap<GameProfile, Map<String, CompoundNBT>>();

    public static List<PlayerEntity> getStrikingPlayers(MinecraftServer server) {
        return PlayerHandler.getPlayers(server, true);
    }

    public static List<PlayerEntity> getNonStrikingPlayers(MinecraftServer server) {
        return PlayerHandler.getPlayers(server, false);
    }

    private static List<PlayerEntity> getPlayers(MinecraftServer server, boolean isStriking) {
        ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>();
        for (ServerPlayerEntity playerEnt : server.func_184103_al().func_181057_v()) {
            ExtendedPlayer playerExt = ExtendedPlayer.get((PlayerEntity)playerEnt);
            if (playerExt == null || playerExt.isOnHungerStrike() != isStriking) continue;
            players.add((PlayerEntity)playerEnt);
        }
        return players;
    }

    public void storeData(PlayerEntity player) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            CompoundNBT data = new CompoundNBT();
            playerExt.saveNBTData(data);
            this.storeData(player, "HungerStrike", data);
        }
    }

    public void storeData(PlayerEntity player, String name, CompoundNBT data) {
        this.storeData(player.func_146103_bH(), name, data);
    }

    public void storeData(GameProfile profile, String name, CompoundNBT data) {
        Map<String, CompoundNBT> store = dataStore.get(profile);
        if (store == null) {
            store = new HashMap<String, CompoundNBT>();
            dataStore.put(profile, store);
        }
        store.put(name, data);
    }

    public void restoreData(PlayerEntity player) {
        CompoundNBT data;
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null && (data = this.getData(player, "HungerStrike")) != null) {
            playerExt.loadNBTData(data);
        }
    }

    public CompoundNBT getData(PlayerEntity player, String name) {
        return this.getData(player.func_146103_bH(), name);
    }

    public CompoundNBT getData(GameProfile profile, String name) {
        Map<String, CompoundNBT> store = dataStore.get(profile);
        if (store == null) {
            return null;
        }
        return store.remove(name);
    }

    public void tick(PlayerEntity player, TickEvent.Phase phase, LogicalSide side) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            playerExt.tick(phase, side);
        }
    }

    public boolean isOnHungerStrike(PlayerEntity player) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            return playerExt.isOnHungerStrike();
        }
        return false;
    }
}

