/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.command;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ModConfig;
import com.jaquadro.minecraft.hungerstrike.PlayerHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponent;

public class HungerStrikeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"hungerstrike").requires(req -> req.func_197034_c(3))).then(Commands.func_197057_a((String)"list").executes(command -> HungerStrikeCommand.listPlayers((CommandSource)command.getSource())))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)GameProfileArgument.func_197108_a()).suggests((command, t) -> {
            PlayerList players = ((CommandSource)command.getSource()).func_197028_i().func_184103_al();
            return ISuggestionProvider.func_197013_a(players.func_181057_v().stream().filter(entity -> {
                ExtendedPlayer player = ExtendedPlayer.get((PlayerEntity)entity);
                return player != null && !player.isOnHungerStrike();
            }).map(entity -> entity.func_146103_bH().getName()), (SuggestionsBuilder)t);
        }).executes(command -> HungerStrikeCommand.addPlayers((CommandSource)command.getSource(), GameProfileArgument.func_197109_a((CommandContext)command, (String)"targets")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"targets", (ArgumentType)GameProfileArgument.func_197108_a()).suggests((command, t) -> {
            PlayerList players = ((CommandSource)command.getSource()).func_197028_i().func_184103_al();
            return ISuggestionProvider.func_197013_a(players.func_181057_v().stream().filter(entity -> {
                ExtendedPlayer player = ExtendedPlayer.get((PlayerEntity)entity);
                return player != null && player.isOnHungerStrike();
            }).map(entity -> entity.func_146103_bH().getName()), (SuggestionsBuilder)t);
        }).executes(command -> HungerStrikeCommand.removePlayers((CommandSource)command.getSource(), GameProfileArgument.func_197109_a((CommandContext)command, (String)"targets")))))).then(Commands.func_197057_a((String)"mode").executes(command -> HungerStrikeCommand.getMode((CommandSource)command.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"setmode").then(Commands.func_197057_a((String)"none").executes(command -> HungerStrikeCommand.setMode((CommandSource)command.getSource(), ModConfig.Mode.NONE)))).then(Commands.func_197057_a((String)"list").executes(command -> HungerStrikeCommand.setMode((CommandSource)command.getSource(), ModConfig.Mode.LIST)))).then(Commands.func_197057_a((String)"all").executes(command -> HungerStrikeCommand.setMode((CommandSource)command.getSource(), ModConfig.Mode.ALL)))));
    }

    private static int listPlayers(CommandSource source) {
        List<String> players = HungerStrikeCommand.playersToNames(PlayerHandler.getStrikingPlayers(source.func_197028_i()));
        if (players.size() == 0) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.list.none"), false);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.list", new Object[]{players.size(), String.join((CharSequence)", ", players)}), false);
        }
        return players.size();
    }

    private static int addPlayers(CommandSource source, Collection<GameProfile> playerProfiles) {
        int addedCount = 0;
        for (GameProfile profile : playerProfiles) {
            ExtendedPlayer player = ExtendedPlayer.get((PlayerEntity)source.func_197028_i().func_184103_al().func_177451_a(profile.getId()));
            if (player == null || player.isOnHungerStrike()) continue;
            player.enableHungerStrike(true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.add.success", new Object[]{TextComponentUtils.func_197679_a((GameProfile)profile)}), true);
            ++addedCount;
        }
        return addedCount;
    }

    private static int removePlayers(CommandSource source, Collection<GameProfile> playerProfiles) {
        int removedCount = 0;
        for (GameProfile profile : playerProfiles) {
            ExtendedPlayer player = ExtendedPlayer.get((PlayerEntity)source.func_197028_i().func_184103_al().func_177451_a(profile.getId()));
            if (player == null || !player.isOnHungerStrike()) continue;
            player.enableHungerStrike(false);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.remove.success", new Object[]{TextComponentUtils.func_197679_a((GameProfile)profile)}), true);
            ++removedCount;
        }
        return removedCount;
    }

    private static int getMode(CommandSource source) {
        ModConfig.Mode mode = (ModConfig.Mode)((Object)ModConfig.GENERAL.mode.get());
        if (mode == ModConfig.Mode.NONE) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.mode.none"), false);
        } else if (mode == ModConfig.Mode.LIST) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.mode.list"), false);
        } else if (mode == ModConfig.Mode.ALL) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.mode.all"), false);
        }
        return 1;
    }

    private static int setMode(CommandSource source, ModConfig.Mode mode) {
        ModConfig.GENERAL.mode.set((Object)mode);
        if (mode == ModConfig.Mode.NONE) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.setmode.none"), true);
        } else if (mode == ModConfig.Mode.LIST) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.setmode.list"), true);
        } else if (mode == ModConfig.Mode.ALL) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hungerstrike.setmode.all"), true);
        }
        return 1;
    }

    private static List<String> playersToNames(List<PlayerEntity> players) {
        ArrayList<String> playerNames = new ArrayList<String>(players.size());
        for (PlayerEntity player : players) {
            playerNames.add(player.func_200200_C_().getString());
        }
        return playerNames;
    }
}

