/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ConfigManager;
import com.jaquadro.minecraft.hungerstrike.HungerStrike;
import com.jaquadro.minecraft.hungerstrike.network.SyncExtendedPlayerMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static final String TAG = "HungerStrike";
    private final EntityPlayer player;
    private boolean hungerStrikeEnabled;
    private int startHunger;

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.hungerStrikeEnabled = false;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(TAG, (IExtendedEntityProperties)new ExtendedPlayer(player));
    }

    public static final ExtendedPlayer get(EntityPlayer player) {
        return (ExtendedPlayer)player.getExtendedProperties(TAG);
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74757_a("Enabled", this.hungerStrikeEnabled);
        compound.func_74782_a(TAG, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(TAG);
        this.hungerStrikeEnabled = properties.func_74767_n("Enabled");
    }

    public void saveNBTDataSync(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74757_a("Enabled", this.hungerStrikeEnabled);
        compound.func_74782_a(TAG, (NBTBase)properties);
    }

    public void enableHungerStrike(boolean enable) {
        if (this.hungerStrikeEnabled != enable) {
            this.hungerStrikeEnabled = enable;
            if (this.player instanceof EntityPlayerMP) {
                HungerStrike.network.sendTo((IMessage)new SyncExtendedPlayerMessage(this.player), (EntityPlayerMP)this.player);
            }
        }
    }

    public boolean isOnHungerStrike() {
        return this.hungerStrikeEnabled;
    }

    private boolean shouldTick() {
        ConfigManager.Mode mode = HungerStrike.config.getMode();
        if (mode == ConfigManager.Mode.LIST) {
            return this.hungerStrikeEnabled;
        }
        return mode == ConfigManager.Mode.ALL;
    }

    public void tick(TickEvent.Phase phase, Side side) {
        if (!this.shouldTick()) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            this.tickStart();
        } else if (phase == TickEvent.Phase.END) {
            this.tickEnd(side);
        }
    }

    private void tickStart() {
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
        this.startHunger = this.player.func_71024_bL().func_75116_a();
    }

    private void tickEnd(Side side) {
        int foodDiff;
        if (side == Side.SERVER && (foodDiff = this.player.func_71024_bL().func_75116_a() - this.startHunger) > 0) {
            this.player.func_70691_i((float)foodDiff * (float)HungerStrike.config.getFoodHealFactor());
        }
        this.setFoodData(this.player.func_71024_bL(), this.calcBaselineHunger(), 1.0f);
    }

    private void setFoodData(FoodStats foodStats, int foodLevel, float saturationLevel) {
        foodStats.func_75122_a(1, (saturationLevel - foodStats.func_75115_e()) / 2.0f);
        foodStats.func_75122_a(foodLevel - foodStats.func_75116_a(), 0.0f);
    }

    private int calcBaselineHunger() {
        if (this.player.func_70644_a(Potion.field_76438_s)) {
            return 5;
        }
        if (this.player.func_70644_a(Potion.field_76428_l)) {
            return 20;
        }
        return HungerStrike.config.getHungerBaseline();
    }
}

